/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ptable;

import com.android.tools.adtui.ptable.PNameRenderer;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableCellRenderer;
import com.android.tools.adtui.ptable.PTableCellRendererProvider;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.editors.layoutInspector.ptable.LITableNameRenderer;
import com.android.tools.idea.editors.layoutInspector.ui.PropertiesTablePanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class LITableRendererProvider
implements PTableCellRendererProvider {
    private static LITableRendererProvider ourInstance = new LITableRendererProvider();
    private final LITableNameRenderer myNameRenderer = new LITableNameRenderer();
    private final LIItemCellRenderer myItemCellRenderer = new LIItemCellRenderer();

    public static LITableRendererProvider getInstance() {
        if (ourInstance == null) {
            ourInstance = new LITableRendererProvider();
        }
        return ourInstance;
    }

    private LITableRendererProvider() {
    }

    @NotNull
    public PNameRenderer getNameCellRenderer(@NotNull PTableItem item) {
        return this.myNameRenderer;
    }

    @NotNull
    public TableCellRenderer getValueCellRenderer(@NotNull PTableItem item) {
        return item.hasChildren() ? LITableRendererProvider.createGroupTableCellRenderer() : this.myItemCellRenderer;
    }

    private static ColoredTableCellRenderer createGroupTableCellRenderer() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                this.setBackground(selected ? UIUtil.getTableSelectionBackground() : PropertiesTablePanel.GROUP_BACKGROUND_COLOR);
            }
        };
    }

    private static class LIItemCellRenderer
    extends PTableCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));

        public LIItemCellRenderer() {
            this.myPanel.add((Component)((Object)this), "Center");
        }

        public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.myPanel.setForeground(this.getForeground());
            this.myPanel.setBackground(this.getBackground());
            if (!isSelected) {
                this.myPanel.setBackground((Color)PropertiesTablePanel.ITEM__BACKGROUND_COLOR);
            }
            return this.myPanel;
        }

        public void customizeCellRenderer(@NotNull PTable table, @NotNull PTableItem item, boolean selected, boolean hasFocus, int row, int col) {
            this.appendValue(item);
        }

        private void appendValue(PTableItem item) {
            String value = item.getValue();
            String text = StringUtil.notNullize((String)value);
            if (!item.isDefaultValue(value)) {
                this.setForeground((Color)JBColor.BLUE);
            }
            this.append(text, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.setToolTipText(text);
        }
    }
}

