/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.XmlNode;
import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestUtils {
    private ManifestUtils() {
    }

    @Nullable
    public static SourceFilePosition getSourceFilePosition(@NotNull Module module, @NotNull String activityName) {
        MergedManifest mergedManifest = MergedManifest.get(module);
        Element item = mergedManifest.findActivity(activityName);
        if (item == null) {
            return null;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(mergedManifest, item);
        if (records.isEmpty()) {
            return null;
        }
        return ManifestUtils.getActionLocation(module, records.get(0));
    }

    @NotNull
    public static List<? extends Actions.Record> getRecords(@NotNull MergedManifest manifest, @NotNull Node item) {
        Actions actions = manifest.getActions();
        if (actions != null) {
            if (item instanceof Element) {
                Element element = (Element)item;
                XmlNode.NodeKey key = ManifestUtils.getNodeKey(manifest, element);
                return actions.getNodeRecords(key);
            }
            if (item instanceof Attr) {
                XmlNode.NodeName name;
                Attr attribute = (Attr)item;
                Element element = attribute.getOwnerElement();
                XmlNode.NodeKey key = ManifestUtils.getNodeKey(manifest, element);
                ImmutableList attributeRecords = actions.getAttributeRecords(key, name = XmlNode.fromXmlName((String)attribute.getName()));
                if (!attributeRecords.isEmpty()) {
                    return attributeRecords;
                }
                return actions.getNodeRecords(key);
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    static XmlNode.NodeKey getNodeKey(@NotNull MergedManifest manifest, @NotNull Element element) {
        XmlNode.NodeKey key = manifest.getNodeKey(element.getNodeName());
        if (key == null) {
            Attr nameAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (nameAttribute != null) {
                key = manifest.getNodeKey(element.getTagName() + "#" + nameAttribute.getValue());
            } else {
                Attr glEsVersionAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "glEsVersion");
                if (glEsVersionAttribute != null) {
                    key = manifest.getNodeKey(element.getTagName() + "#" + glEsVersionAttribute.getValue());
                } else {
                    NodeList children = element.getChildNodes();
                    ArrayList<String> names = new ArrayList<String>(children.getLength());
                    for (int i = 0; i < children.getLength(); ++i) {
                        Attr childAttribute;
                        Node child = children.item(i);
                        if (child.getNodeType() != 1 || (childAttribute = ((Element)child).getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null) continue;
                        names.add(childAttribute.getValue());
                    }
                    Collections.sort(names);
                    key = manifest.getNodeKey(element.getTagName() + "#" + Joiner.on((char)'+').join(names));
                }
            }
        }
        return key;
    }

    @Nullable
    public static Node getSourceNode(@NotNull Module module, @NotNull Actions.Record record) {
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file != null && !SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
            assert (vFile != null);
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module.getProject());
            if (fileModule != null && !fileModule.equals(module)) {
                MergedManifest manifest = MergedManifest.get(fileModule);
                Document document = manifest.getDocument();
                assert (document != null);
                Element root = document.getDocumentElement();
                assert (root != null);
                int startLine = sourcePosition.getStartLine();
                int startColumn = sourcePosition.getStartColumn();
                return PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)startColumn);
            }
            int startLine = sourcePosition.getStartLine();
            int startColumn = sourcePosition.getStartColumn();
            try {
                byte[] bytes = Files.toByteArray((File)file);
                Document document = PositionXmlParser.parse((byte[])bytes);
                return PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)startColumn);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    static SourceFilePosition getActionLocation(@NotNull Module module, @NotNull Actions.Record record) {
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file != null && !SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
            assert (vFile != null);
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module.getProject());
            if (fileModule != null && !fileModule.equals(module)) {
                int startColumn;
                MergedManifest manifest = MergedManifest.get(fileModule);
                Document document = manifest.getDocument();
                assert (document != null);
                Element root = document.getDocumentElement();
                assert (root != null);
                int startLine = sourcePosition.getStartLine();
                Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document, (int)startLine, (int)(startColumn = sourcePosition.getStartColumn()));
                if (node == null) {
                    Logger.getInstance(ManifestPanel.class).warn("Can not find node in " + fileModule + " for " + sourceFilePosition);
                } else {
                    List<? extends Actions.Record> records = ManifestUtils.getRecords(manifest, node);
                    if (!records.isEmpty()) {
                        return ManifestUtils.getActionLocation(fileModule, records.get(0));
                    }
                }
            }
        }
        return sourceFilePosition;
    }

    @Nullable
    public static IdeaSourceProvider findManifestSourceProvider(@NotNull AndroidFacet facet, @NotNull VirtualFile manifestFile) {
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            if (!manifestFile.equals(provider.getManifestFile())) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static XmlFile getMainManifest(@NotNull AndroidFacet facet) {
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet);
        assert (manifestFile != null);
        PsiFile psiFile = PsiManager.getInstance((Project)facet.getModule().getProject()).findFile(manifestFile);
        assert (psiFile != null);
        return (XmlFile)psiFile;
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Node item) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (item instanceof Element) {
            ManifestUtils.toolsRemove(manifest, (Element)item);
        } else if (item instanceof Attr) {
            Attr attribute = (Attr)item;
            Element element = attribute.getOwnerElement();
            if ("name".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) || LintUtils.getChildCount((Node)element) == 0 && element.getAttributes().getLength() == 1) {
                ManifestUtils.toolsRemove(manifest, element);
            } else {
                ManifestUtils.toolsRemove(manifest, attribute);
            }
        }
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Element item) {
        ManifestUtils.addToolsAttribute(manifest, item, "node", "remove");
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Attr item) {
        ManifestUtils.addToolsAttribute(manifest, item.getOwnerElement(), "remove", item.getName());
    }

    static void addToolsAttribute(@NotNull XmlFile manifest, @NotNull Element item, @NotNull String attributeName, @NotNull String attributeValue) {
        if (attributeName.contains(":")) {
            throw new IllegalArgumentException("should not have namespace as it's always tools");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        AndroidResourceUtil.ensureNamespaceImported(manifest, "http://schemas.android.com/tools", null);
        XmlTag parent = null;
        XmlTag[] manifestTags = new XmlTag[]{manifest.getRootTag()};
        for (Element tag : ManifestUtils.getPath(item)) {
            XmlTag found = ManifestUtils.findTag(manifestTags, tag);
            if (found == null) {
                if (parent == null) {
                    Logger.getInstance(ManifestUtils.class).warn("can not root tag " + tag + " in xml file " + manifest);
                    return;
                }
                found = parent.createChildTag(tag.getLocalName(), null, null, false);
                found = parent.addSubTag(found, true);
                Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameAttribute != null) {
                    found.setAttribute(nameAttribute.getLocalName(), nameAttribute.getNamespaceURI(), nameAttribute.getValue());
                }
                if (tag == item) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                }
            } else if (tag == item) {
                XmlAttribute attribute = found.getAttribute(attributeName, "http://schemas.android.com/tools");
                if (attribute == null) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                } else {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attribute.getValue() + "," + attributeValue);
                }
            }
            parent = found;
            manifestTags = found.getSubTags();
        }
    }

    @Nullable
    private static XmlTag findTag(@NotNull XmlTag[] manifestTags, @NotNull Element tag) {
        Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        String name = nameAttribute == null ? null : nameAttribute.getValue();
        for (XmlTag xmlTag : manifestTags) {
            if (!tag.getTagName().equals(xmlTag.getName())) continue;
            if (name != null) {
                XmlAttribute xmlAttribute = xmlTag.getAttribute("name", "http://schemas.android.com/apk/res/android");
                if (xmlAttribute == null || !name.equals(xmlAttribute.getValue())) continue;
                return xmlTag;
            }
            return xmlTag;
        }
        return null;
    }

    @NotNull
    private static List<Element> getPath(@NotNull Element element) {
        Element tag = element;
        ArrayList<Element> path = new ArrayList<Element>();
        while (true) {
            path.add(tag);
            Node parentNode = tag.getParentNode();
            if (!(parentNode instanceof Element)) break;
            tag = (Element)parentNode;
        }
        Collections.reverse(path);
        return path;
    }
}

