/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.NewStringKeyDialog;
import com.android.tools.idea.editors.strings.StringPsiUtils;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

final class AddKeyAction
extends AnAction {
    private final StringResourceViewPanel myPanel;

    AddKeyAction(@NotNull StringResourceViewPanel panel) {
        super("Add Key", null, AllIcons.ToolbarDecorator.Add);
        this.myPanel = panel;
    }

    public void update(@NotNull AnActionEvent event) {
        event.getPresentation().setEnabled(this.myPanel.getTable().getData() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        StringResourceKey key;
        AndroidFacet facet = this.myPanel.getFacet();
        StringResourceData data = this.myPanel.getTable().getData();
        assert (data != null);
        NewStringKeyDialog dialog = new NewStringKeyDialog(facet, (Collection<StringResourceKey>)new HashSet(data.getKeys()));
        if (!dialog.showAndGet()) {
            return;
        }
        Project project = facet.getModule().getProject();
        XmlFile file = StringPsiUtils.getDefaultStringResourceFile(project, key = dialog.getKey());
        if (file == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            StringPsiUtils.addString(file, key, dialog.getDefaultValue());
            this.myPanel.reloadData();
        });
    }
}

