/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.table.NeedsTranslationForLocaleRowFilter;
import com.android.tools.idea.editors.strings.table.NeedsTranslationsRowFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.TextRowFilter;
import com.android.tools.idea.rendering.Locale;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.DialogBuilder;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilterKeysAction
extends ComboBoxAction {
    private final StringResourceTable myTable;

    FilterKeysAction(@NotNull StringResourceTable table) {
        this.myTable = table;
    }

    public void update(@NotNull AnActionEvent event) {
        StringResourceTableRowFilter filter = this.myTable.getRowFilter();
        if (filter == null) {
            Presentation presentation = event.getPresentation();
            presentation.setIcon(null);
            presentation.setText("Show All Keys");
        } else {
            filter.update(event.getPresentation());
        }
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@Nullable JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        group.add(new AnAction("Show All Keys"){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(null);
            }
        });
        group.add(new AnAction("Show Translatable Keys"){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationsRowFilter(true));
            }
        });
        group.add(new AnAction("Show Keys Needing Translations"){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationsRowFilter(false));
            }
        });
        group.add(new AnAction("Filter by Text", "Filter the translations editor table keys by text", AllIcons.General.Filter){

            public void actionPerformed(@Nullable AnActionEvent e) {
                String filterString;
                JTextField textField = new JTextField();
                DialogBuilder builder = new DialogBuilder();
                builder.setTitle("Filter by Text");
                builder.setCenterPanel((JComponent)textField);
                builder.setPreferredFocusComponent((JComponent)textField);
                if (builder.showAndGet() && !(filterString = textField.getText()).isEmpty()) {
                    FilterKeysAction.this.myTable.setRowFilter(new TextRowFilter(filterString));
                }
            }
        });
        StringResourceTableModel model = this.myTable.getModel();
        IntStream.range(4, model.getColumnCount()).mapToObj(model::getLocale).map(this::newShowKeysNeedingTranslationForLocaleAction).forEach(arg_0 -> ((DefaultActionGroup)group).add(arg_0));
        return group;
    }

    @NotNull
    private AnAction newShowKeysNeedingTranslationForLocaleAction(final @NotNull Locale locale) {
        String text = "Show Keys Needing a Translation for " + LocaleMenuAction.getLocaleLabel(locale, false);
        return new AnAction(text, null, locale.getFlagImage()){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationForLocaleRowFilter(locale));
            }
        };
    }
}

