/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.table.LocaleColumnFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableColumnFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilterLocalesAction
extends ComboBoxAction {
    private static final String NO_FILTER_TITLE = "Show All Locales";
    private final StringResourceTable myTable;

    FilterLocalesAction(@NotNull StringResourceTable table) {
        this.myTable = table;
    }

    public void update(@NotNull AnActionEvent event) {
        StringResourceTableColumnFilter filter = this.myTable.getColumnFilter();
        if (filter == null) {
            Presentation presentation = event.getPresentation();
            presentation.setIcon(null);
            presentation.setText(NO_FILTER_TITLE);
        } else {
            filter.update(event.getPresentation());
        }
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@Nullable JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        group.add(new AnAction(NO_FILTER_TITLE){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterLocalesAction.this.myTable.setColumnFilter(null);
            }
        });
        StringResourceTableModel model = this.myTable.getModel();
        IntStream.range(4, model.getColumnCount()).mapToObj(model::getLocale).map(this::newShowLocaleAction).forEach(arg_0 -> ((DefaultActionGroup)group).add(arg_0));
        return group;
    }

    @NotNull
    private AnAction newShowLocaleAction(final @NotNull Locale locale) {
        String text = "Show " + LocaleMenuAction.getLocaleLabel(locale, false);
        return new AnAction(text, null, locale.getFlagImage()){

            public void actionPerformed(@Nullable AnActionEvent event) {
                FilterLocalesAction.this.myTable.setColumnFilter(new LocaleColumnFilter(locale));
            }
        };
    }
}

