/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.google.common.collect.Sets;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Font;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static Font getFontAbleToDisplay(@NotNull String s, @NotNull Font defaultFont) {
        if (SystemInfo.isMac || FontUtil.isExtendedAscii(s)) {
            return defaultFont;
        }
        HashSet fonts = Sets.newHashSetWithExpectedSize((int)10);
        FontPreferences fontPreferences = EditorColorsManager.getInstance().getGlobalScheme().getFontPreferences();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u00ff') continue;
            fonts.add(ComplementaryFontsRegistry.getFontAbleToDisplay((int)s.charAt(i), (int)0, (FontPreferences)fontPreferences, null).getFont());
        }
        if (fonts.isEmpty()) {
            return defaultFont;
        }
        Font bestFont = defaultFont;
        int max = 0;
        for (Font f : fonts) {
            int supportedChars = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (!f.canDisplay(s.charAt(i))) continue;
                ++supportedChars;
            }
            if (supportedChars <= max) continue;
            max = supportedChars;
            bestFont = f;
        }
        return bestFont;
    }

    private static boolean isExtendedAscii(@NotNull String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }
}

