/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.DelegateDeleteHandler;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RemoveKeysAction
extends AnAction {
    private final StringResourceViewPanel myPanel;

    RemoveKeysAction(@NotNull StringResourceViewPanel panel) {
        super("Remove Keys", null, AllIcons.ToolbarDecorator.Remove);
        this.myPanel = panel;
    }

    public void update(@NotNull AnActionEvent event) {
        event.getPresentation().setEnabled(this.myPanel.getTable().getSelectedRowCount() != 0);
    }

    public void actionPerformed(@Nullable AnActionEvent event) {
        StringResourceTable table = this.myPanel.getTable();
        StringResourceTableModel model = table.getModel();
        StringResourceRepository repository = this.myPanel.getRepository();
        Project project = this.myPanel.getFacet().getModule().getProject();
        PsiElement[] elements = (PsiElement[])Arrays.stream(table.getSelectedRowModelIndices()).mapToObj(index -> model.getStringResourceAt(index).getKey()).flatMap(key -> repository.getItems((StringResourceKey)key).stream()).map(item -> LocalResourceRepository.getItemTag(project, item)).toArray(PsiElement[]::new);
        DelegateDeleteHandler.deletePsiElement(project, elements, this.myPanel.getFacet().getModule());
    }
}

