/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NotNull;

final class RemoveLocaleMouseListener
extends MouseAdapter {
    private final StringResourceViewPanel myPanel;

    RemoveLocaleMouseListener(@NotNull StringResourceViewPanel panel) {
        this.myPanel = panel;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent event) {
        this.showRemoveLocalePopupMenu(event);
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent event) {
        this.showRemoveLocalePopupMenu(event);
    }

    private void showRemoveLocalePopupMenu(@NotNull MouseEvent event) {
        Point point;
        if (!event.isPopupTrigger()) {
            return;
        }
        JTableHeader header = (JTableHeader)event.getSource();
        int column = header.columnAtPoint(point = event.getPoint());
        if (column == -1) {
            return;
        }
        JTable table = header.getTable();
        Locale locale = ((StringResourceTableModel)table.getModel()).getLocale(table.convertColumnIndexToModel(column));
        if (locale == null) {
            return;
        }
        JBMenuItem item = new JBMenuItem("Remove Locale");
        item.setName("removeLocaleMenuItem");
        item.addActionListener(e -> {
            StringsWriteUtils.removeLocale(locale, this.myPanel.getFacet(), this);
            this.myPanel.reloadData();
        });
        JBPopupMenu menu = new JBPopupMenu();
        menu.add((JMenuItem)item);
        menu.show(header, point.x, point.y);
    }
}

