/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class SelectedEditorFeature
implements FileEditorManagerListener {
    private final Project myProject;
    private final FileEditor myEditor;
    private boolean myOpen;
    private boolean mySelected;
    private boolean myFeatureStarted;

    public SelectedEditorFeature(@NotNull FileEditor editor, @NotNull Project project) {
        this.myProject = project;
        this.myEditor = editor;
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)editor);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
    }

    public void selectNotify() {
        if (!this.myOpen) {
            this.myOpen = true;
            this.mySelected = Arrays.asList(FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()).contains(this.myEditor);
            this.startFeature();
        }
    }

    public void deselectNotify() {
        if (this.myOpen) {
            this.myOpen = false;
            this.mySelected = false;
            this.stopFeature();
        }
    }

    private void startFeature() {
        if (this.myOpen && this.mySelected && !this.myFeatureStarted) {
            if (this.isReady()) {
                this.open();
                this.myFeatureStarted = true;
            } else {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ApplicationManager.getApplication().invokeLater(this::startFeature), 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void stopFeature() {
        if (this.myFeatureStarted) {
            this.myFeatureStarted = false;
            this.close();
        }
    }

    public abstract boolean isReady();

    public abstract void open();

    public abstract void close();

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event.getNewEditor() == this.myEditor) {
            this.myOpen = true;
            this.mySelected = true;
            this.startFeature();
        } else if (event.getOldEditor() == this.myEditor) {
            this.mySelected = false;
            this.stopFeature();
        }
    }
}

