/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import android.text.Html;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.swing.layoutlib.AndroidPreviewPanel;
import com.intellij.openapi.module.Module;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StringPreview {
    private final AndroidPreviewPanel myPreview;

    public StringPreview(@NotNull Module module) {
        Configuration config = ThemeEditorUtils.getConfigurationForModule(module);
        this.myPreview = new AndroidPreviewPanel(config);
        Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element textView = document.createElement("TextView");
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
        attr.setValue("http://schemas.android.com/apk/res/android");
        textView.getAttributes().setNamedItemNS(attr);
        textView.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_width", "fill_parent");
        textView.setAttributeNS("http://schemas.android.com/apk/res/android", "layout_height", "fill_parent");
        textView.setAttributeNS("http://schemas.android.com/apk/res/android", "background", "?android:attr/colorBackground");
        document.appendChild(textView);
        this.myPreview.setDocument(document);
    }

    public JComponent getComponent() {
        return this.myPreview;
    }

    public void setText(@NotNull String text) {
        List<ViewInfo> views;
        if (text.startsWith("<![CDATA[") && text.endsWith("]]>")) {
            text = text.substring("<![CDATA[".length(), text.length() - "]]>".length());
        }
        if (!(views = this.myPreview.getRootViews()).isEmpty() && views.get(0).getViewObject() instanceof TextView) {
            TextView textView = (TextView)views.get(0).getViewObject();
            textView.setText((CharSequence)Html.fromHtml((String)text, (int)63));
            this.myPreview.revalidate();
            this.myPreview.repaint();
        }
    }
}

