/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ValueXmlHelper;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StringPsiUtils {
    private StringPsiUtils() {
    }

    @Nullable
    static XmlFile getDefaultStringResourceFile(@NotNull Project project, @NotNull StringResourceKey key) {
        VirtualFile directory = key.getDirectory();
        return directory == null ? null : StringsWriteUtils.getStringResourceFile(project, directory, null);
    }

    @Nullable
    static XmlFile getStringResourceFile(@NotNull Project project, @NotNull StringResourceKey key, @NotNull Locale locale) {
        VirtualFile directory = key.getDirectory();
        return directory == null ? null : StringsWriteUtils.getStringResourceFile(project, directory, locale);
    }

    static void addString(@NotNull XmlFile file, @NotNull StringResourceKey key, @NotNull String value) {
        StringPsiUtils.addString(file, key, true, value);
    }

    static void addString(@NotNull XmlFile file, @NotNull StringResourceKey key, boolean translatable, @NotNull String value) {
        XmlTag resources = file.getRootTag();
        if (resources == null) {
            return;
        }
        XmlTag string = resources.createChildTag("string", resources.getNamespace(), StringPsiUtils.escape(value), false);
        string.setAttribute("name", key.getName());
        if (!translatable) {
            string.setAttribute("translatable", Boolean.FALSE.toString());
        }
        resources.addSubTag(string, false);
    }

    @NotNull
    private static String escape(@NotNull String value) {
        try {
            return ValueXmlHelper.escapeResourceStringAsXml((String)value);
        }
        catch (IllegalArgumentException exception) {
            return value;
        }
    }
}

