/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringPsiUtils;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.VirtualFiles;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResource {
    @NotNull
    private final StringResourceKey myKey;
    @NotNull
    private final String myResourceFolder;
    private boolean myTranslatable;
    @NotNull
    private ResourceItemEntry myDefaultValue;
    @NotNull
    private final Map<Locale, ResourceItemEntry> myLocaleToTranslationMap;
    @NotNull
    private final StringResourceRepository myRepository;
    @NotNull
    private final Project myProject;

    public StringResource(@NotNull StringResourceKey key, @NotNull StringResourceRepository repository, @NotNull Project project) {
        boolean translatable = true;
        ResourceItemEntry defaultValue = new ResourceItemEntry();
        HashMap<Locale, ResourceItemEntry> localeToTranslationMap = new HashMap<Locale, ResourceItemEntry>();
        for (ResourceItem item : repository.getItems(key)) {
            LocaleQualifier qualifier;
            XmlTag tag = LocalResourceRepository.getItemTag(project, item);
            if (tag != null && "false".equals(tag.getAttributeValue("translatable"))) {
                translatable = false;
            }
            if ((qualifier = item.getConfiguration().getLocaleQualifier()) == null) {
                defaultValue = new ResourceItemEntry(item);
                continue;
            }
            localeToTranslationMap.put(Locale.create(qualifier), new ResourceItemEntry(item));
        }
        this.myKey = key;
        VirtualFile folder = key.getDirectory();
        this.myResourceFolder = folder == null ? "" : VirtualFiles.toString(folder, project);
        this.myTranslatable = translatable;
        this.myDefaultValue = defaultValue;
        this.myLocaleToTranslationMap = localeToTranslationMap;
        this.myRepository = repository;
        this.myProject = project;
    }

    @NotNull
    StringResourceKey getKey() {
        return this.myKey;
    }

    @NotNull
    public String getResourceFolder() {
        return this.myResourceFolder;
    }

    @Nullable
    ResourceItem getDefaultValueAsResourceItem() {
        return this.myDefaultValue.myResourceItem;
    }

    @NotNull
    public String getDefaultValueAsString() {
        return this.myDefaultValue.myString;
    }

    public boolean setDefaultValue(@NotNull String defaultValue) {
        if (this.myDefaultValue.myResourceItem == null) {
            ResourceItem item = this.createDefaultValue(defaultValue);
            if (item == null) {
                return false;
            }
            this.myDefaultValue = new ResourceItemEntry(item);
            return true;
        }
        if (this.myDefaultValue.myString.equals(defaultValue)) {
            return false;
        }
        boolean changed = StringsWriteUtils.setItemText(this.myProject, this.myDefaultValue.myResourceItem, defaultValue);
        if (!changed) {
            return false;
        }
        if (defaultValue.isEmpty()) {
            this.myDefaultValue = new ResourceItemEntry();
            return true;
        }
        ResourceItem item = this.myRepository.getDefaultValue(this.myKey);
        assert (item != null);
        this.myDefaultValue = new ResourceItemEntry(item);
        return true;
    }

    @Nullable
    private ResourceItem createDefaultValue(@NotNull String value) {
        if (value.isEmpty()) {
            return null;
        }
        XmlFile file = StringPsiUtils.getDefaultStringResourceFile(this.myProject, this.myKey);
        if (file == null) {
            return null;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> StringPsiUtils.addString(file, this.myKey, this.myTranslatable, value));
        return this.myRepository.getDefaultValue(this.myKey);
    }

    @Nullable
    public String validateDefaultValue() {
        if (this.myDefaultValue.myResourceItem == null) {
            return "Key \"" + this.myKey.getName() + "\" is missing its default value";
        }
        if (!this.myDefaultValue.myStringValid) {
            return "Invalid XML";
        }
        return null;
    }

    public boolean isTranslatable() {
        return this.myTranslatable;
    }

    public void setTranslatable(boolean translatable) {
        this.myTranslatable = translatable;
    }

    @Nullable
    ResourceItem getTranslationAsResourceItem(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        return resourceItemEntry == null ? null : resourceItemEntry.myResourceItem;
    }

    @NotNull
    public String getTranslationAsString(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry = this.myLocaleToTranslationMap.get(locale);
        return resourceItemEntry == null ? "" : resourceItemEntry.myString;
    }

    public boolean putTranslation(@NotNull Locale locale, @NotNull String translation) {
        if (this.getTranslationAsResourceItem(locale) == null) {
            ResourceItem item = this.createTranslation(locale, translation);
            if (item == null) {
                return false;
            }
            this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(item));
            return true;
        }
        if (this.getTranslationAsString(locale).equals(translation)) {
            return false;
        }
        ResourceItem item = this.getTranslationAsResourceItem(locale);
        assert (item != null);
        boolean changed = StringsWriteUtils.setItemText(this.myProject, item, translation);
        if (!changed) {
            return false;
        }
        if (translation.isEmpty()) {
            this.myLocaleToTranslationMap.remove(locale);
            return true;
        }
        item = this.myRepository.getTranslation(this.myKey, locale);
        assert (item != null);
        this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(item));
        return true;
    }

    @Nullable
    private ResourceItem createTranslation(@NotNull Locale locale, @NotNull String value) {
        if (value.isEmpty()) {
            return null;
        }
        XmlFile file = StringPsiUtils.getStringResourceFile(this.myProject, this.myKey, locale);
        if (file == null) {
            return null;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> StringPsiUtils.addString(file, this.myKey, this.myTranslatable, value));
        return this.myRepository.getTranslation(this.myKey, locale);
    }

    @Nullable
    public String validateTranslation(@NotNull Locale locale) {
        ResourceItemEntry entry = this.myLocaleToTranslationMap.get(locale);
        if (entry != null && !entry.myStringValid) {
            return "Invalid XML";
        }
        if (this.myTranslatable && this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is missing its " + LocaleMenuAction.getLocaleLabel(locale, false) + " translation";
        }
        if (!this.myTranslatable && !this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is untranslatable and should not be translated to " + LocaleMenuAction.getLocaleLabel(locale, false);
        }
        return null;
    }

    @NotNull
    Collection<Locale> getTranslatedLocales() {
        return this.myLocaleToTranslationMap.keySet();
    }

    boolean isTranslationMissing(@NotNull Locale locale) {
        ResourceItemEntry item = this.myLocaleToTranslationMap.get(locale);
        if (StringResource.isTranslationMissing(item) && locale.hasRegion()) {
            locale = Locale.create(locale.qualifier.getLanguage());
            item = this.myLocaleToTranslationMap.get(locale);
        }
        return StringResource.isTranslationMissing(item);
    }

    private static boolean isTranslationMissing(@Nullable ResourceItemEntry item) {
        return item == null || item.myString.isEmpty();
    }

    private static final class ResourceItemEntry {
        @Nullable
        private final ResourceItem myResourceItem;
        @NotNull
        private final String myString;
        private final boolean myStringValid;

        public ResourceItemEntry() {
            this.myResourceItem = null;
            this.myString = "";
            this.myStringValid = true;
        }

        private ResourceItemEntry(@NotNull ResourceItem resourceItem) {
            boolean stringValid;
            this.myResourceItem = resourceItem;
            ResourceValue value = resourceItem.getResourceValue(false);
            if (value == null) {
                this.myString = "";
                this.myStringValid = true;
                return;
            }
            String string = value.getRawXmlValue();
            try {
                string = ValueXmlHelper.unescapeResourceStringAsXml((String)string);
                stringValid = true;
            }
            catch (IllegalArgumentException exception) {
                stringValid = false;
            }
            this.myString = string;
            this.myStringValid = stringValid;
        }
    }
}

