/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceData {
    private final AndroidFacet myFacet;
    private final Map<StringResourceKey, StringResource> myKeyToResourceMap;

    public StringResourceData(@NotNull AndroidFacet facet, @NotNull Map<StringResourceKey, StringResource> keyToResourceMap) {
        this.myFacet = facet;
        this.myKeyToResourceMap = keyToResourceMap;
    }

    public void changeKeyName(@NotNull StringResourceKey key, @NotNull String newName) {
        ResourceItem res = this.getStringResource(key).getDefaultValueAsResourceItem();
        if (res == null) {
            return;
        }
        XmlTag tag = LocalResourceRepository.getItemTag(this.myFacet.getModule().getProject(), res);
        assert (tag != null);
        XmlAttribute name = tag.getAttribute("name");
        assert (name != null);
        XmlAttributeValue nameValue = name.getValueElement();
        assert (nameValue != null);
        RenameProcessor rename = new RenameProcessor(this.myFacet.getModule().getProject(), (PsiElement)nameValue, newName, false, false);
        ApplicationManager.getApplication().invokeLater((Runnable)rename);
    }

    public boolean setTranslatable(@NotNull StringResourceKey key, boolean translatable) {
        StringResource stringResource = this.getStringResource(key);
        ResourceItem item = stringResource.getDefaultValueAsResourceItem();
        if (item != null) {
            String translatableAsString;
            if (translatable) {
                translatableAsString = null;
                stringResource.setTranslatable(true);
            } else {
                translatableAsString = "false";
                stringResource.setTranslatable(false);
            }
            return StringsWriteUtils.setAttributeForItems(this.myFacet.getModule().getProject(), "translatable", translatableAsString, Collections.singletonList(item));
        }
        return false;
    }

    @Nullable
    public String validateKey(@NotNull StringResourceKey key) {
        if (!this.myKeyToResourceMap.keySet().contains(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        StringResource stringResource = this.getStringResource(key);
        if (!stringResource.isTranslatable()) {
            Collection<Locale> localesWithTranslation = stringResource.getTranslatedLocales();
            if (!localesWithTranslation.isEmpty()) {
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (stringResource.getDefaultValueAsResourceItem() == null) {
                return "Key '" + key.getName() + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    @NotNull
    Collection<Locale> getMissingTranslations(@NotNull StringResourceKey key) {
        HashSet missingTranslations = Sets.newHashSet();
        for (Locale locale : this.getLocaleSet()) {
            StringResource stringResource = this.getStringResource(key);
            if (!stringResource.isTranslationMissing(locale)) continue;
            missingTranslations.add(locale);
        }
        return missingTranslations;
    }

    @NotNull
    static String summarizeLocales(@NotNull Collection<Locale> locales) {
        if (locales.isEmpty()) {
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            return StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
        }
        int max = 3;
        List<Locale> sorted = StringResourceData.getLowest(locales, 3);
        if (size <= 3) {
            return StringResourceData.getLabels(sorted.subList(0, size - 1)) + " and " + StringResourceData.getLabel(sorted.get(size - 1));
        }
        return String.format("%1$s and %2$d more", StringResourceData.getLabels(sorted), size - 3);
    }

    private static List<Locale> getLowest(Collection<Locale> locales, int n) {
        return locales.stream().limit(n).sorted(Comparator.comparing(StringResourceData::getLabel)).collect(Collectors.toList());
    }

    private static String getLabels(Collection<Locale> locales) {
        return locales.stream().map(StringResourceData::getLabel).collect(Collectors.joining(", "));
    }

    private static String getLabel(@Nullable Locale locale) {
        return locale == null ? "" : LocaleMenuAction.getLocaleLabel(locale, false);
    }

    boolean containsKey(@NotNull StringResourceKey key) {
        return this.myKeyToResourceMap.containsKey(key);
    }

    @NotNull
    public StringResource getStringResource(@NotNull StringResourceKey key) {
        StringResource resource = this.myKeyToResourceMap.get(key);
        if (resource == null) {
            throw new IllegalArgumentException(key.toString());
        }
        return resource;
    }

    @NotNull
    public Collection<StringResource> getResources() {
        return this.myKeyToResourceMap.values();
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        return new ArrayList<StringResourceKey>(this.myKeyToResourceMap.keySet());
    }

    @NotNull
    public List<Locale> getLocaleList() {
        return this.getTranslatedLocaleStream().distinct().sorted(Locale.LANGUAGE_NAME_COMPARATOR).collect(Collectors.toList());
    }

    @NotNull
    Set<Locale> getLocaleSet() {
        return this.getTranslatedLocaleStream().collect(Collectors.toSet());
    }

    @NotNull
    private Stream<Locale> getTranslatedLocaleStream() {
        return this.myKeyToResourceMap.values().stream().flatMap(resource -> resource.getTranslatedLocales().stream());
    }
}

