/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class StringResourceEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final String ID = "string-resource-editor";

    public static boolean canViewTranslations(@NotNull Project project, @NotNull VirtualFile file) {
        String name = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
        assert (name != null);
        if (!file.getName().endsWith(name)) {
            return false;
        }
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.VALUES) {
            return false;
        }
        Module m = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(file);
        return m != null && AndroidFacet.getInstance(m) != null;
    }

    public static void openEditor(@NotNull Module module) {
        StringsVirtualFile vf = StringsVirtualFile.getStringsVirtualFile(module);
        if (vf != null) {
            ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$0(module, (VirtualFile)vf));
        }
    }

    public static void openEditor(@NotNull Project project, @NotNull VirtualFile file) {
        StringsVirtualFile stringsFile = StringsVirtualFile.getInstance(project, file);
        assert (stringsFile != null);
        ApplicationManager.getApplication().invokeLater(() -> StringResourceEditorProvider.lambda$openEditor$1(project, (VirtualFile)stringsFile));
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        return file instanceof StringsVirtualFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return new StringResourceEditor((StringsVirtualFile)file);
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
    }

    @NotNull
    public String getEditorTypeId() {
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }

    private static /* synthetic */ void lambda$openEditor$1(@NotNull Project project, VirtualFile stringsFile) {
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, stringsFile);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static /* synthetic */ void lambda$openEditor$0(@NotNull Module module, VirtualFile vf) {
        Project project = module.getProject();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, vf);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }
}

