/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResourceKey
implements Comparable<StringResourceKey> {
    private static final Comparator<StringResourceKey> COMPARATOR = Comparator.comparing(StringResourceKey::getName).thenComparing(key -> key.myDirectory == null ? "" : key.myDirectory.getPath());
    private final String myName;
    private final VirtualFile myDirectory;

    public StringResourceKey(@NotNull String name, @Nullable VirtualFile directory) {
        this.myName = name;
        this.myDirectory = directory;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public VirtualFile getDirectory() {
        return this.myDirectory;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof StringResourceKey)) {
            return false;
        }
        StringResourceKey key = (StringResourceKey)object;
        return this.myName.equals(key.myName) && Objects.equals(this.myDirectory, key.myDirectory);
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.myDirectory);
    }

    @NotNull
    public String toString() {
        return this.myDirectory == null ? this.myName : this.myName + " (" + this.myDirectory + ')';
    }

    @Override
    public int compareTo(@NotNull StringResourceKey key) {
        return COMPARATOR.compare(this, key);
    }
}

