/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceRepository {
    private final Map<StringResourceKey, LocalResourceRepository> myKeyToRepositoryMap = new LinkedHashMap<StringResourceKey, LocalResourceRepository>();

    public StringResourceRepository(@NotNull MultiResourceRepository parent) {
        for (LocalResourceRepository localResourceRepository : parent.getChildren()) {
            VirtualFile directory = localResourceRepository instanceof ResourceFolderRepository ? ((ResourceFolderRepository)localResourceRepository).getResourceDir() : null;
            localResourceRepository.sync();
            for (String name : localResourceRepository.getItemsOfType(ResourceType.STRING)) {
                this.myKeyToRepositoryMap.put(new StringResourceKey(name, directory), localResourceRepository);
            }
        }
    }

    @NotNull
    final StringResourceData getData(@NotNull AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        Map map = this.myKeyToRepositoryMap.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> new StringResource((StringResourceKey)key, this, project), (resource1, resource2) -> {
            throw new IllegalStateException("Duplicate key " + resource1);
        }, LinkedHashMap::new));
        return new StringResourceData(facet, map);
    }

    @NotNull
    public Collection<ResourceItem> getItems(@NotNull StringResourceKey key) {
        return StringResourceRepository.getItems(this.myKeyToRepositoryMap.get(key), key);
    }

    @Nullable
    final ResourceItem getDefaultValue(@NotNull StringResourceKey key) {
        return this.getItem(key, item -> item.getConfiguration().getLocaleQualifier() == null);
    }

    @Nullable
    final ResourceItem getTranslation(@NotNull StringResourceKey key, @NotNull Locale locale) {
        return this.getItem(key, item -> StringResourceRepository.localeEquals((Configurable)item, locale));
    }

    private static boolean localeEquals(@NotNull Configurable item, @NotNull Locale locale) {
        LocaleQualifier qualifier = item.getConfiguration().getLocaleQualifier();
        return qualifier != null && Locale.create(qualifier).equals(locale);
    }

    @Nullable
    private ResourceItem getItem(@NotNull StringResourceKey key, @NotNull Predicate<ResourceItem> predicate) {
        LocalResourceRepository repository = this.myKeyToRepositoryMap.get(key);
        repository.sync();
        Optional<ResourceItem> optionalItem = StringResourceRepository.getItems(repository, key).stream().filter(predicate).findFirst();
        return optionalItem.orElse(null);
    }

    @NotNull
    private static Collection<ResourceItem> getItems(@NotNull AbstractResourceRepository repository, @NotNull StringResourceKey key) {
        List items = repository.getResourceItem(ResourceType.STRING, key.getName());
        return items == null ? Collections.emptyList() : items;
    }
}

