/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.intellij.ui.components.JBTextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.IntSupplier;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

final class TranslationsEditorTextField
extends JBTextField {
    private final StringResourceTable myTable;
    private final IntSupplier myColumnSupplier;
    private SetTableValueAtTimer myTimer;

    TranslationsEditorTextField(@NotNull StringResourceTable table, int column) {
        this(table, () -> column);
    }

    TranslationsEditorTextField(final @NotNull StringResourceTable table, @NotNull IntSupplier columnSupplier) {
        this.myTable = table;
        this.myColumnSupplier = columnSupplier;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(@NotNull KeyEvent event) {
                int rowCount = table.getSelectedRowCount();
                int columnCount = table.getSelectedColumnCount();
                if (rowCount != 1 || columnCount != 1) {
                    return;
                }
                if (TranslationsEditorTextField.this.myTimer == null || TranslationsEditorTextField.this.myTimer.isDone()) {
                    TranslationsEditorTextField.this.myTimer = new SetTableValueAtTimer(TranslationsEditorTextField.this.myTable, TranslationsEditorTextField.this.myColumnSupplier);
                }
                TranslationsEditorTextField.this.myTimer.setValue(((JTextComponent)event.getSource()).getText());
                TranslationsEditorTextField.this.myTimer.restart();
            }
        });
    }

    private static final class SetTableValueAtTimer
    extends Timer {
        private String myValue;
        private boolean myDone;

        private SetTableValueAtTimer(@NotNull StringResourceTable table, @NotNull IntSupplier columnSupplier) {
            super(500, null);
            this.setRepeats(false);
            int row = table.getSelectedRowModelIndex();
            int column = columnSupplier.getAsInt();
            this.addActionListener(event -> {
                table.getModel().setValueAt(this.myValue, row, column);
                table.refilter();
                this.myDone = true;
            });
        }

        private void setValue(@NotNull String value) {
            this.myValue = value;
        }

        private boolean isDone() {
            return this.myDone;
        }
    }
}

