/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.stream.IntStream;
import javax.swing.RowFilter;
import org.jetbrains.annotations.NotNull;

public final class NeedsTranslationsRowFilter
extends StringResourceTableRowFilter {
    private final boolean myShowAll;

    public NeedsTranslationsRowFilter(boolean showAll) {
        this.myShowAll = showAll;
    }

    @Override
    public void update(@NotNull Presentation presentation) {
        presentation.setIcon(null);
        presentation.setText(this.myShowAll ? "Show Translatable Keys" : "Show Keys Needing Translations");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean include(@NotNull RowFilter.Entry<? extends StringResourceTableModel, ? extends Integer> entry) {
        if (((Boolean)entry.getValue(2)).booleanValue()) {
            return false;
        }
        if (this.myShowAll) return true;
        if (!IntStream.range(3, entry.getValueCount()).mapToObj(entry::getStringValue).anyMatch(String::isEmpty)) return false;
        return true;
    }
}

