/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.adtui.TableUtils;
import com.android.tools.adtui.ui.FixedColumnTable;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.LocaleRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableColumnFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.StringTableCellEditor;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.android.tools.idea.rendering.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResourceTable
extends FixedColumnTable
implements DataProvider,
PasteProvider {
    @Nullable
    private StringResourceTableColumnFilter myColumnFilter;
    private boolean myColumnPreferredWidthsSet;

    public StringResourceTable() {
        super((TableModel)new StringResourceTableModel());
        CellEditorListener editorListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent event) {
                StringResourceTable.this.refilter();
            }

            @Override
            public void editingCanceled(ChangeEvent event) {
            }
        };
        this.getDefaultEditor(Boolean.class).addCellEditorListener(editorListener);
        StringTableCellEditor editor = new StringTableCellEditor();
        editor.addCellEditorListener(editorListener);
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "delete");
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setDefaultEditor(String.class, editor);
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringsCellRenderer()));
        this.setFixedColumnCount(2);
        this.setRowSorter(new ThreeStateTableRowSorter<StringResourceTableModel>(this.getModel()));
        new TableSpeedSearch((JTable)((Object)this));
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        JBTable.JBTableHeader header = new JBTable.JBTableHeader((JBTable)this);
        header.setName("tableHeader");
        header.setReorderingAllowed(false);
        return header;
    }

    @Nullable
    public StringResourceData getData() {
        return this.getModel().getData();
    }

    public void refilter() {
        ((DefaultRowSorter)this.getRowSorter()).sort();
    }

    @Nullable
    public StringResourceTableRowFilter getRowFilter() {
        return (StringResourceTableRowFilter)((DefaultRowSorter)this.getRowSorter()).getRowFilter();
    }

    public void setRowFilter(@Nullable StringResourceTableRowFilter filter) {
        ((DefaultRowSorter)this.getRowSorter()).setRowFilter(filter);
    }

    @Nullable
    public StringResourceTableColumnFilter getColumnFilter() {
        return this.myColumnFilter;
    }

    public void setColumnFilter(@Nullable StringResourceTableColumnFilter filter) {
        this.myColumnFilter = filter;
        this.createDefaultColumnsFromModel();
    }

    public void createDefaultColumnsFromModel() {
        this.addColumns(this.removeAllColumns());
    }

    @NotNull
    private Map<String, TableColumn> removeAllColumns() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)this.getTotalColumnCount());
        while (this.getTotalColumnCount() != 0) {
            TableColumn column = this.getColumn(0);
            this.removeColumn(column);
            map.put((String)column.getHeaderValue(), column);
        }
        return map;
    }

    private void addColumns(@NotNull Map<String, TableColumn> map) {
        StringResourceTableModel model = this.getModel();
        LocaleRenderer renderer = this.tableHeader == null ? null : new LocaleRenderer(this.tableHeader.getDefaultRenderer());
        IntStream.range(0, model.getColumnCount()).filter(this::includeColumn).mapToObj(column -> this.getColumn(map, column, renderer)).forEach(arg_0 -> ((StringResourceTable)this).addColumn(arg_0));
    }

    private boolean includeColumn(int column) {
        if (column < 4) {
            return true;
        }
        if (this.myColumnFilter == null) {
            return true;
        }
        Locale locale = this.getModel().getLocale(column);
        assert (locale != null);
        return this.myColumnFilter.include(locale);
    }

    @NotNull
    private TableColumn getColumn(@NotNull Map<String, TableColumn> map, int column, @Nullable TableCellRenderer renderer) {
        TableColumn tableColumn = map.get(this.dataModel.getColumnName(column));
        if (tableColumn == null) {
            tableColumn = new TableColumn(column);
            if (column >= 4 && renderer != null) {
                tableColumn.setHeaderRenderer(renderer);
            }
        } else {
            tableColumn.setModelIndex(column);
        }
        return tableColumn;
    }

    public int getSelectedRowModelIndex() {
        return this.convertRowIndexToModel(this.getSelectedRow());
    }

    @NotNull
    public int[] getSelectedRowModelIndices() {
        return Arrays.stream(this.getSelectedRows()).map(arg_0 -> this.convertRowIndexToModel(arg_0)).toArray();
    }

    public int getSelectedColumnModelIndex() {
        return this.convertColumnIndexToModel(this.getSelectedColumn());
    }

    public TableRowSorter<StringResourceTableModel> getRowSorter() {
        return (TableRowSorter)super.getRowSorter();
    }

    public StringResourceTableModel getModel() {
        return (StringResourceTableModel)super.getModel();
    }

    public void setModel(@NotNull TableModel model) {
        super.setModel(model);
        RowSorter sorter = this.getRowSorter();
        if (sorter != null) {
            ((TableRowSorter)sorter).setModel(this.getModel());
        }
        if (this.tableHeader == null) {
            return;
        }
        if (this.myColumnPreferredWidthsSet) {
            return;
        }
        OptionalInt optionalWidth = this.getKeyColumnPreferredWidth();
        if (optionalWidth.isPresent()) {
            this.getColumn(0).setPreferredWidth(optionalWidth.getAsInt());
        }
        if ((optionalWidth = this.getDefaultValueAndLocaleColumnPreferredWidths()).isPresent()) {
            int width = optionalWidth.getAsInt();
            IntStream.range(this.convertColumnIndexToView(3), this.getColumnCount()).mapToObj(this.columnModel::getColumn).forEach(column -> column.setPreferredWidth(width));
        }
        this.myColumnPreferredWidthsSet = true;
    }

    @NotNull
    @VisibleForTesting
    public OptionalInt getKeyColumnPreferredWidth() {
        return IntStream.range(0, this.getModel().getRowCount()).map(row -> this.getPreferredWidth(this.getCellRendererAtModel(row, 0), this.getModel().getValueAt(row, 0), row, 0)).max();
    }

    @NotNull
    @VisibleForTesting
    public OptionalInt getDefaultValueAndLocaleColumnPreferredWidths() {
        return IntStream.range(this.convertColumnIndexToView(3), this.getColumnCount()).map(column -> this.getPreferredWidth(this.getHeaderRenderer(column), this.getColumnName(column), -1, column)).max();
    }

    @NotNull
    private TableCellRenderer getHeaderRenderer(int column) {
        TableCellRenderer renderer = this.columnModel.getColumn(column).getHeaderRenderer();
        return renderer == null ? this.tableHeader.getDefaultRenderer() : renderer;
    }

    private int getPreferredWidth(@NotNull TableCellRenderer renderer, @NotNull Object value, int row, int column) {
        return renderer.getTableCellRendererComponent((JTable)((Object)this), (Object)value, (boolean)false, (boolean)false, (int)row, (int)column).getPreferredSize().width + 2;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        return dataId.equals(PlatformDataKeys.PASTE_PROVIDER.getName()) ? this : null;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            return false;
        }
        int column = this.getSelectedColumn();
        return column != 0 && column != 2;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable != null) {
            TableUtils.paste((JTable)((Object)this), (Transferable)transferable);
        }
    }

    static class ThreeStateTableRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        public ThreeStateTableRowSorter(M model) {
            super(model);
        }

        @Override
        public void toggleSortOrder(int column) {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            if (!sortKeys.isEmpty() && sortKeys.get(0).getSortOrder() == SortOrder.DESCENDING) {
                this.setSortKeys(null);
                return;
            }
            super.toggleSortOrder(column);
        }

        @Override
        public void modelStructureChanged() {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            super.modelStructureChanged();
            this.setSortKeys(sortKeys);
        }
    }
}

