/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceTableModel
extends AbstractTableModel {
    public static final int KEY_COLUMN = 0;
    public static final int RESOURCE_FOLDER_COLUMN = 1;
    public static final int UNTRANSLATABLE_COLUMN = 2;
    public static final int DEFAULT_VALUE_COLUMN = 3;
    public static final int FIXED_COLUMN_COUNT = 4;
    private final StringResourceData myData;
    private final List<StringResourceKey> myKeys;
    private final List<Locale> myLocales;

    StringResourceTableModel() {
        this.myData = null;
        this.myKeys = Collections.emptyList();
        this.myLocales = Collections.emptyList();
    }

    public StringResourceTableModel(@NotNull StringResourceData data) {
        this.myData = data;
        this.myKeys = data.getKeys();
        this.myLocales = data.getLocaleList();
    }

    @Nullable
    public StringResourceData getData() {
        return this.myData;
    }

    @NotNull
    public StringResource getStringResourceAt(int row) {
        return this.myData.getStringResource(this.getKey(row));
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        return this.myKeys;
    }

    @NotNull
    public StringResourceKey getKey(int row) {
        return this.myKeys.get(row);
    }

    @Nullable
    public Locale getLocale(int column) {
        assert (0 <= column && column < this.getColumnCount()) : column;
        return column < 4 ? null : this.myLocales.get(column - 4);
    }

    @Override
    public int getRowCount() {
        return this.myKeys.size();
    }

    @Override
    public int getColumnCount() {
        return 4 + this.myLocales.size();
    }

    @Override
    public void setValueAt(@NotNull Object value, int row, int column) {
        assert (this.myData != null && this.myKeys != null);
        switch (column) {
            case 0: {
                String oldName = this.getKey(row).getName();
                String newName = (String)value;
                if (StringUtil.equals((CharSequence)oldName, (CharSequence)newName)) break;
                this.myData.changeKeyName(this.getKey(row), newName);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Boolean doNotTranslate = (Boolean)value;
                if (!this.myData.setTranslatable(this.getKey(row), doNotTranslate == false)) break;
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 3: {
                if (!this.getStringResourceAt(row).setDefaultValue((String)value)) break;
                this.fireTableCellUpdated(row, column);
                break;
            }
            default: {
                Locale locale = this.getLocale(column);
                assert (locale != null);
                if (!this.getStringResourceAt(row).putTranslation(locale, (String)value)) break;
                this.fireTableCellUpdated(row, column);
            }
        }
    }

    @Override
    @NotNull
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.getKey(row).getName();
            }
            case 1: {
                return this.getStringResourceAt(row).getResourceFolder();
            }
            case 2: {
                return !this.getStringResourceAt(row).isTranslatable();
            }
            case 3: {
                return this.getStringResourceAt(row).getDefaultValueAsString();
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        return this.getStringResourceAt(row).getTranslationAsString(locale);
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Key";
            }
            case 1: {
                return "Resource Folder";
            }
            case 2: {
                return "Untranslatable";
            }
            case 3: {
                return "Default Value";
            }
        }
        return LocaleMenuAction.getLocaleLabel(this.getLocale(column), false);
    }

    public Class getColumnClass(int column) {
        return column == 2 ? Boolean.class : String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return !this.getStringResourceAt(row).getDefaultValueAsString().contains("\n");
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        return !this.getStringResourceAt(row).getTranslationAsString(locale).contains("\n");
    }

    @Nullable
    public String getCellProblem(int row, int column) {
        switch (column) {
            case 0: {
                return this.myData.validateKey(this.getKey(row));
            }
            case 1: 
            case 2: {
                return null;
            }
            case 3: {
                return this.getStringResourceAt(row).validateDefaultValue();
            }
        }
        Locale locale = this.getLocale(column);
        assert (locale != null);
        return this.getStringResourceAt(row).validateTranslation(locale);
    }
}

