/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.ide.common.res2.ValueXmlHelper;
import com.android.tools.idea.editors.strings.FontUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class StringTableCellEditor
extends DefaultCellEditor {
    StringTableCellEditor() {
        this(new JTextField());
    }

    StringTableCellEditor(@NotNull JTextField component2) {
        super(component2);
    }

    public void setCellEditorValue(@NotNull Object value) {
        this.delegate.setValue(value);
    }

    @Override
    public JTextComponent getComponent() {
        return (JTextComponent)this.editorComponent;
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table, @NotNull Object value, boolean selected, int row, int column) {
        JComponent component2 = (JComponent)super.getTableCellEditorComponent(table, value, selected, row, column);
        component2.setBorder(new LineBorder((Color)JBColor.BLACK));
        component2.setFont(FontUtil.getFontAbleToDisplay((String)value, component2.getFont()));
        return component2;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            ValueXmlHelper.escapeResourceStringAsXml((String)((String)this.getCellEditorValue()));
            return super.stopCellEditing();
        }
        catch (IllegalArgumentException exception) {
            this.getComponent().setBorder(new LineBorder((Color)JBColor.RED));
            return false;
        }
    }
}

