/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.intellij.openapi.actionSystem.Presentation;
import javax.swing.RowFilter;
import org.jetbrains.annotations.NotNull;

public class TextRowFilter
extends StringResourceTableRowFilter {
    @NotNull
    private final String myText;

    public TextRowFilter(@NotNull String text) {
        this.myText = text;
    }

    @Override
    public boolean include(RowFilter.Entry<? extends StringResourceTableModel, ? extends Integer> entry) {
        for (int i = 0; i < entry.getValueCount(); ++i) {
            String text = entry.getStringValue(i);
            if (!text.contains(this.myText)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(@NotNull Presentation presentation) {
        presentation.setIcon(null);
        presentation.setText("Show Keys with Values Containing \"" + this.myText + '\"');
    }
}

