/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ColorPaletteComponent
implements Icon {
    private static final int ICON_SIZE = JBUI.scale((int)20);
    private static final int PADDING = JBUI.scale((int)2);
    private Color myPrimaryColor = null;
    private Color myPrimaryDarkColor = null;
    private Color myAccentColor = null;

    public void setValues(@NotNull Color primaryColor, @NotNull Color primaryDarkColor, @NotNull Color accentColor) {
        this.myPrimaryColor = primaryColor;
        this.myPrimaryDarkColor = primaryDarkColor;
        this.myAccentColor = accentColor;
    }

    public void reset() {
        this.myPrimaryColor = null;
        this.myPrimaryDarkColor = null;
        this.myAccentColor = null;
    }

    public void paintColoredSquare(@NotNull Color color, @NotNull Graphics g, int x, int y, int w) {
        if (color.getAlpha() != 255) {
            com.android.tools.adtui.util.GraphicsUtil.paintCheckeredBackground((Graphics)g, (Shape)new Rectangle(x, y, w, w));
        }
        g.setColor(color);
        g.fillRect(x, y, w, w);
    }

    @Override
    public void paintIcon(Component component2, Graphics graphics, int i, int i1) {
        if (this.myPrimaryColor != null && this.myPrimaryDarkColor != null && this.myAccentColor != null) {
            GraphicsUtil.setupAAPainting((Graphics)graphics);
            Graphics2D g = (Graphics2D)graphics.create();
            this.paintColoredSquare(this.myPrimaryColor, g, i + PADDING, i1 + PADDING, ICON_SIZE);
            this.paintColoredSquare(this.myPrimaryDarkColor, g, i + 2 * PADDING + ICON_SIZE, i1 + PADDING, ICON_SIZE);
            this.paintColoredSquare(this.myAccentColor, g, i + 3 * PADDING + 2 * ICON_SIZE, i1 + PADDING, ICON_SIZE);
            g.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return (ICON_SIZE + PADDING) * 3 + PADDING;
    }

    @Override
    public int getIconHeight() {
        return ICON_SIZE + 2 * PADDING;
    }
}

