/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class ColorRendererEditor
extends GraphicalResourceRendererEditor {
    public ColorRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        super(context, previewPanel, isEditor);
    }

    @Override
    protected void updateComponent(@NotNull ThemeEditorContext context, @NotNull ResourceComponent component2, @NotNull EditedStyleItem item) {
        ResourceSwatchComponent.SwatchIcon icon;
        ResourceResolver resourceResolver = context.getResourceResolver();
        assert (resourceResolver != null);
        List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, (ResourceValue)item.getSelectedValue(), context.getProject());
        if (colors.isEmpty()) {
            icon = ResourceSwatchComponent.WARNING_ICON;
        } else {
            icon = new ResourceSwatchComponent.ColorIcon((Color)Iterables.getLast(colors));
            icon.setIsStack(colors.size() > 1);
        }
        component2.setSwatchIcon(icon);
        component2.setNameText(item.getQualifiedName());
        component2.setValueText(item.getValue());
        if (!colors.isEmpty()) {
            Color color = (Color)Iterables.getLast(colors);
            String attributeName = item.getName();
            ImmutableMap<String, Color> contrastColorsWithDescription = ColorUtils.getContrastColorsWithDescription(context, attributeName);
            component2.setWarning(ColorUtils.getContrastWarningMessage(contrastColorsWithDescription, color, ColorUtils.isBackgroundAttribute(attributeName)));
        } else {
            component2.setWarning(null);
        }
    }

    @Override
    @NotNull
    protected EnumSet<ResourceType> getAllowedResourceTypes() {
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(this.myContext.getConfiguration(), this.myItem.getSelectedValue());
        String attributeName = this.myItem.getName().toLowerCase(Locale.ENGLISH);
        if (attributeName.contains("color") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Reference)) {
            return COLORS_ONLY;
        }
        if (attributeName.contains("drawable") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
            return DRAWABLES_ONLY;
        }
        return COLORS_AND_DRAWABLES;
    }
}

