/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.DumbAwareActionListener;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellRendererEditor;
import com.android.tools.idea.editors.theme.attributes.variants.VariantItemListener;
import com.android.tools.idea.editors.theme.attributes.variants.VariantsComboItem;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedConfiguration;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JTable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GraphicalResourceRendererEditor
extends TypedCellRendererEditor<EditedStyleItem, String> {
    public static final EnumSet<ResourceType> COLORS_ONLY = EnumSet.of(ResourceType.COLOR);
    public static final EnumSet<ResourceType> DRAWABLES_ONLY = EnumSet.of(ResourceType.DRAWABLE, ResourceType.MIPMAP);
    public static final EnumSet<ResourceType> COLORS_AND_DRAWABLES = EnumSet.of(ResourceType.COLOR, ResourceType.DRAWABLE, ResourceType.MIPMAP);
    static final String DUMB_MODE_MESSAGE = "Editing theme is not possible - indexing is in progress";
    private static final Logger LOG = Logger.getInstance(GraphicalResourceRendererEditor.class);
    private static final Comparator<VariantsComboItem> VARIANTS_COMBO_ITEM_COMPARATOR = new Comparator<VariantsComboItem>(){

        @Override
        public int compare(VariantsComboItem o1, VariantsComboItem o2) {
            FolderConfiguration o1FolderConfiguration = o1.getOriginalConfiguration();
            FolderConfiguration o2FolderConfiguration = o2.getOriginalConfiguration();
            if (o1FolderConfiguration.isDefault() && !o2FolderConfiguration.isDefault()) {
                return -1;
            }
            if (o2FolderConfiguration.isDefault() && !o1FolderConfiguration.isDefault()) {
                return 1;
            }
            return o1FolderConfiguration.toShortDisplayString().compareTo(o2FolderConfiguration.toShortDisplayString());
        }
    };
    protected final ThemeEditorContext myContext;
    protected final ResourceComponent myComponent;
    protected final AndroidThemePreviewPanel myPreviewPanel;
    protected AttributesTableModel myModel;
    protected EditedStyleItem myItem;

    public GraphicalResourceRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        this.myContext = context;
        this.myComponent = new ResourceComponent(context.getProject(), isEditor){

            @Override
            public boolean isShowing() {
                return true;
            }
        };
        if (isEditor) {
            this.myComponent.addVariantItemListener(new VariantItemListener(context));
            this.myComponent.addVariantItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GraphicalResourceRendererEditor.this.stopCellEditing();
                }
            });
            this.myComponent.addVariantPopupClosingListener(new VariantsComboBox.PopupClosingListener(){

                @Override
                public void popupClosed() {
                    GraphicalResourceRendererEditor.this.stopCellEditing();
                }
            });
            this.myComponent.addSwatchListener(new EditorClickListener());
            this.myComponent.addTextListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphicalResourceRendererEditor.this.stopCellEditing();
                }
            });
            this.myComponent.addTextFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    DumbService dumbService = DumbService.getInstance((Project)GraphicalResourceRendererEditor.this.myContext.getProject());
                    if (dumbService.isDumb()) {
                        dumbService.showDumbModeNotification(GraphicalResourceRendererEditor.DUMB_MODE_MESSAGE);
                        GraphicalResourceRendererEditor.this.cancelCellEditing();
                    } else {
                        AndroidFacet facet = AndroidFacet.getInstance(GraphicalResourceRendererEditor.this.myContext.getCurrentContextModule());
                        assert (facet != null);
                        GraphicalResourceRendererEditor.this.myComponent.setCompletionStrings(ResourceHelper.getCompletionFromTypes(facet, GraphicalResourceRendererEditor.this.getAllowedResourceTypes()));
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    GraphicalResourceRendererEditor.this.cancelCellEditing();
                }
            });
        }
        this.myPreviewPanel = previewPanel;
    }

    private static void updateComponentInternal(@NotNull ResourceComponent component2, @NotNull EditedStyleItem item) {
        String currentVariantColor = ColorUtil.toHex((Color)ThemeEditorConstants.CURRENT_VARIANT_COLOR);
        String notSelectedVariantColor = ColorUtil.toHex((Color)ThemeEditorConstants.NOT_SELECTED_VARIANT_COLOR);
        FolderConfiguration restrictedConfig = RestrictedConfiguration.restrict(item.getSelectedItemResourceValue(), item.getAllConfiguredItems());
        String description = String.format("<html><nobr><font color=\"#%1$s\">%2$s", currentVariantColor, item.getSelectedValueConfiguration().toShortDisplayString());
        VariantsComboItem selectedItem = new VariantsComboItem(description, restrictedConfig != null ? restrictedConfig : item.getSelectedValueConfiguration(), item.getSelectedValueConfiguration());
        TreeSet notSelectedItems = Sets.newTreeSet(VARIANTS_COMBO_ITEM_COMPARATOR);
        for (ConfiguredElement<ItemResourceValue> configuredItem : item.getNonSelectedItemResourceValues()) {
            restrictedConfig = RestrictedConfiguration.restrict(configuredItem, item.getAllConfiguredItems());
            if (restrictedConfig == null) {
                LOG.warn(String.format("For item '%1$s': Folder configuration '%2$s' can never be selected. There are no qualifiers combination that would allow selecting it.", item.getName(), configuredItem.getConfiguration()));
                continue;
            }
            description = String.format("<html><nobr><b><font color=\"#%1$s\">%2$s</font></b><font color=\"#9B9B9B\"> %3$s</font>", notSelectedVariantColor, configuredItem.getConfiguration().toShortDisplayString(), " - " + configuredItem.getElement().getValue());
            notSelectedItems.add(new VariantsComboItem(description, restrictedConfig, configuredItem.getConfiguration()));
        }
        ImmutableList variantList = ImmutableList.builder().add((Object)selectedItem).addAll((Iterable)notSelectedItems).build();
        component2.setVariantsModel((ComboBoxModel)new CollectionComboBoxModel((List)variantList, (Object)selectedItem));
    }

    protected abstract void updateComponent(@NotNull ThemeEditorContext var1, @NotNull ResourceComponent var2, @NotNull EditedStyleItem var3);

    @Override
    public Component getRendererComponent(JTable table, EditedStyleItem obj, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myItem = obj;
        this.myComponent.setSize(table.getCellRect(row, column, false).getSize());
        Font font = table.getFont();
        this.myComponent.setFont(ThemeEditorUtils.scaleFontForAttribute(font));
        GraphicalResourceRendererEditor.updateComponentInternal(this.myComponent, obj);
        this.updateComponent(this.myContext, this.myComponent, obj);
        return this.myComponent;
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myModel = (AttributesTableModel)table.getModel();
        this.myItem = value;
        this.myComponent.setSize(table.getCellRect(row, column, false).getSize());
        Font font = table.getFont();
        this.myComponent.setFont(ThemeEditorUtils.scaleFontForAttribute(font));
        GraphicalResourceRendererEditor.updateComponentInternal(this.myComponent, value);
        this.updateComponent(this.myContext, this.myComponent, value);
        return this.myComponent;
    }

    @Override
    public String getEditorValue() {
        return this.myComponent.getValueText();
    }

    @NotNull
    protected abstract EnumSet<ResourceType> getAllowedResourceTypes();

    private class EditorClickListener
    extends DumbAwareActionListener {
        public EditorClickListener() {
            super(GraphicalResourceRendererEditor.this.myContext.getProject());
        }

        @Override
        public void dumbActionPerformed(ActionEvent e) {
            DumbService.getInstance((Project)GraphicalResourceRendererEditor.this.myContext.getProject()).showDumbModeNotification(GraphicalResourceRendererEditor.DUMB_MODE_MESSAGE);
            GraphicalResourceRendererEditor.this.cancelCellEditing();
        }

        @Override
        public void smartActionPerformed(ActionEvent e) {
            ImmutableMap<String, Color> contrastColorsWithDescription;
            ConfiguredThemeEditorStyle style = GraphicalResourceRendererEditor.this.myModel.getSelectedStyle();
            ResourceResolver styleResourceResolver = GraphicalResourceRendererEditor.this.myContext.getResourceResolver();
            assert (styleResourceResolver != null);
            ItemResourceValue primaryColorResourceValue = ThemeEditorUtils.resolveItemFromParents(style, "colorPrimary", !ThemeEditorUtils.isAppCompatTheme(style));
            final Project project = GraphicalResourceRendererEditor.this.myContext.getProject();
            Color primaryColor = ResourceHelper.resolveColor((RenderResources)styleResourceResolver, (ResourceValue)primaryColorResourceValue, project);
            ChooseResourceDialog dialog = ThemeEditorUtils.getResourceDialog(GraphicalResourceRendererEditor.this.myItem, GraphicalResourceRendererEditor.this.myContext, GraphicalResourceRendererEditor.this.getAllowedResourceTypes());
            String attributeName = GraphicalResourceRendererEditor.this.myItem.getName();
            if (primaryColor != null) {
                dialog.generateColorSuggestions(primaryColor, attributeName);
            }
            if (!(contrastColorsWithDescription = ColorUtils.getContrastColorsWithDescription(GraphicalResourceRendererEditor.this.myContext, attributeName)).isEmpty()) {
                dialog.setContrastParameters(contrastColorsWithDescription, ColorUtils.isBackgroundAttribute(attributeName), true);
            }
            final String oldValue = GraphicalResourceRendererEditor.this.myItem.getSelectedValue().getValue();
            dialog.setResourcePickerListener(new ChooseResourceDialog.ResourcePickerListener(){

                @Override
                public void resourceChanged(@Nullable String resource) {
                    if (resource != null) {
                        Color color;
                        ResourceResolver resourceResolver = GraphicalResourceRendererEditor.this.myContext.getResourceResolver();
                        assert (resourceResolver != null);
                        ResourceValue resValue = resourceResolver.findResValue(resource, false);
                        String resolvedResource = resource;
                        if (resValue != null && resValue.getResourceType() == ResourceType.COLOR && !resValue.getValue().endsWith(".xml") && (color = ResourceHelper.resolveColor((RenderResources)resourceResolver, resValue, project)) != null) {
                            resolvedResource = ResourceHelper.colorToString(color);
                        }
                        GraphicalResourceRendererEditor.this.myItem.getSelectedValue().setValue(resolvedResource);
                    } else {
                        GraphicalResourceRendererEditor.this.myItem.getSelectedValue().setValue(oldValue);
                    }
                    GraphicalResourceRendererEditor.this.myPreviewPanel.invalidateGraphicsRenderer();
                }
            });
            if (e.getSource() instanceof JBMenuItem) {
                dialog.openLocationSettings();
            }
            dialog.show();
            GraphicalResourceRendererEditor.this.myItem.getSelectedValue().setValue(oldValue);
            String editorValue = null;
            if (dialog.isOK()) {
                editorValue = dialog.getResourceName();
            } else {
                GraphicalResourceRendererEditor.this.myPreviewPanel.invalidateGraphicsRenderer();
            }
            if (editorValue == null) {
                GraphicalResourceRendererEditor.this.cancelCellEditing();
            } else {
                GraphicalResourceRendererEditor.this.myComponent.setValueText(editorValue);
                GraphicalResourceRendererEditor.this.stopCellEditing();
            }
        }
    }
}

