/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.preview;

import com.android.tools.adtui.SearchField;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.configurations.OrientationMenuAction;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ThemePreviewComponent
extends JPanel
implements Disposable {
    private final AndroidThemePreviewPanel myPreviewPanel;
    private final ThemeEditorContext myThemeEditorContext;
    private final ScheduledExecutorService mySearchUpdateScheduler;
    private final SearchField myTextField;
    private final JPanel myToolbar;
    private final JComponent myActionToolbarComponent;
    private ScheduledFuture<?> myScheduledSearch;

    public ThemePreviewComponent(@NotNull ThemeEditorContext context) {
        super(new BorderLayout());
        this.myThemeEditorContext = context;
        this.myPreviewPanel = new AndroidThemePreviewPanel(this.myThemeEditorContext, (Color)ThemeEditorComponent.PREVIEW_BACKGROUND);
        this.myPreviewPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        Disposer.register((Disposable)this, (Disposable)this.myPreviewPanel);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OrientationMenuAction(this.myPreviewPanel, null));
        group.add((AnAction)new DeviceMenuAction(this.myPreviewPanel));
        group.add((AnAction)new TargetMenuAction(this.myPreviewPanel, true));
        group.add((AnAction)new LocaleMenuAction(this.myPreviewPanel));
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("ThemeToolbar", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(1);
        this.myToolbar = new JPanel(null);
        this.myToolbar.setLayout(new BoxLayout(this.myToolbar, 0));
        this.myToolbar.setBorder((Border)JBUI.Borders.empty((int)7, (int)14, (int)7, (int)7));
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)this.myPreviewPanel, "Center");
        previewPanel.add((Component)this.myToolbar, "North");
        this.myActionToolbarComponent = actionToolbar.getComponent();
        this.myToolbar.add(this.myActionToolbarComponent);
        this.myTextField = new SearchField(true);
        this.myTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.myTextField.getPreferredSize().height));
        this.mySearchUpdateScheduler = Executors.newSingleThreadScheduledExecutor(ConcurrencyUtil.newNamedThreadFactory((String)"Theme Editor Searcher"));
        this.myTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (ThemePreviewComponent.this.myScheduledSearch != null) {
                    ThemePreviewComponent.this.myScheduledSearch.cancel(false);
                }
                ThemePreviewComponent.this.myScheduledSearch = ThemePreviewComponent.this.mySearchUpdateScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ThemePreviewComponent.this.myPreviewPanel.setSearchTerm(ThemePreviewComponent.this.myTextField.getText());
                    }
                }, 300L, TimeUnit.MILLISECONDS);
            }
        });
        this.myToolbar.add((Component)this.myTextField);
        DefaultActionGroup rightActionGroup = new DefaultActionGroup();
        rightActionGroup.add((AnAction)new BrowserHelpAction("Theme Editor", "https://developer.android.com/r/studio-ui/theme-editor.html"));
        ActionToolbar rightToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)rightActionGroup, true);
        rightToolbar.setLayoutPolicy(0);
        JComponent rightToolbarComponent = rightToolbar.getComponent();
        rightToolbarComponent.setBorder(null);
        rightToolbarComponent.setBackground(null);
        rightToolbarComponent.setOpaque(false);
        rightToolbarComponent.setMaximumSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.myToolbar.add(rightToolbarComponent);
        this.add((Component)this.myPreviewPanel, "Center");
        this.add((Component)this.myToolbar, "North");
        this.setPreviewBackground((Color)ThemeEditorComponent.PREVIEW_BACKGROUND);
    }

    public void setPreviewBackground(@NotNull Color bg) {
        this.myToolbar.setBackground(bg);
        this.myActionToolbarComponent.setBackground(bg);
        this.myTextField.setBackground(bg);
        for (Component component2 : this.myTextField.getComponents()) {
            if (!(component2 instanceof JLabel)) continue;
            component2.setBackground(bg);
        }
        this.myPreviewPanel.setBackground(bg);
    }

    public void reloadPreviewContents() {
        this.myPreviewPanel.invalidateGraphicsRenderer();
        this.myPreviewPanel.revalidate();
    }

    public void dispose() {
        if (this.myScheduledSearch != null) {
            this.myScheduledSearch.cancel(false);
        }
        this.mySearchUpdateScheduler.shutdownNow();
    }

    @NotNull
    public AndroidThemePreviewPanel getPreviewPanel() {
        return this.myPreviewPanel;
    }
}

