/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifierUtils {
    private static final Logger LOG = Logger.getInstance(QualifierUtils.class);

    @NotNull
    public static Object getValue(@NotNull ResourceQualifier qualifier) {
        try {
            Method getValue = qualifier.getClass().getMethod("getValue", new Class[0]);
            return getValue.invoke((Object)qualifier, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public static Class getValueReturnType(@NotNull Class<? extends ResourceQualifier> resourceQualifierClass) {
        try {
            return resourceQualifierClass.getMethod("getValue", new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @NotNull
    public static ResourceQualifier createNewResourceQualifier(@NotNull Class<? extends ResourceQualifier> qualifierClass, @NotNull Object value) {
        try {
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(Integer.class)) {
                Constructor<? extends ResourceQualifier> constructor = qualifierClass.getConstructor(Integer.TYPE);
                return constructor.newInstance((int)((Integer)value));
            }
            Constructor<? extends ResourceQualifier> constructor = qualifierClass.getConstructor(value.getClass());
            return constructor.newInstance(value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }
}

