/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedLocale
implements RestrictedQualifier {
    private String myNeedsToMatch = "__";
    private final Collection<String> myNeedsToNotMatch = Sets.newHashSet();

    @Override
    public void setRestrictions(@Nullable ResourceQualifier compatible, @NotNull Collection<ResourceQualifier> incompatibles) {
        if (compatible != null) {
            this.myNeedsToMatch = ((LocaleQualifier)compatible).getValue();
        } else {
            for (ResourceQualifier qualifier : incompatibles) {
                this.myNeedsToNotMatch.add(((LocaleQualifier)qualifier).getValue());
            }
        }
    }

    @Override
    public boolean isMatchFor(@Nullable ResourceQualifier qualifier) {
        if (qualifier == null) {
            return false;
        }
        String value = ((LocaleQualifier)qualifier).getValue();
        if ("__".equals(this.myNeedsToMatch)) {
            return !this.myNeedsToNotMatch.contains(value);
        }
        return value.equals(this.myNeedsToMatch);
    }

    @Override
    public boolean isEmpty() {
        return this.myNeedsToMatch == null;
    }

    @Override
    @Nullable
    public Object getAny() {
        assert (this.myNeedsToMatch != null);
        if ("__".equals(this.myNeedsToMatch) && this.myNeedsToNotMatch.isEmpty()) {
            return null;
        }
        return this.myNeedsToMatch;
    }

    @Override
    @Nullable
    public RestrictedQualifier intersect(@NotNull RestrictedQualifier otherRestrictedQualifier) {
        assert (otherRestrictedQualifier instanceof RestrictedLocale);
        RestrictedLocale otherRestrictedLocale = (RestrictedLocale)otherRestrictedQualifier;
        RestrictedLocale result = new RestrictedLocale();
        result.myNeedsToNotMatch.addAll(this.myNeedsToNotMatch);
        result.myNeedsToNotMatch.addAll(otherRestrictedLocale.myNeedsToNotMatch);
        if (!otherRestrictedLocale.myNeedsToMatch.equals("__")) {
            result.myNeedsToMatch = otherRestrictedLocale.myNeedsToMatch;
        }
        if (!this.myNeedsToMatch.equals("__")) {
            if (!result.myNeedsToMatch.equals("__") && !result.myNeedsToMatch.equals(this.myNeedsToMatch)) {
                return null;
            }
            result.myNeedsToMatch = this.myNeedsToMatch;
        }
        if (result.myNeedsToMatch.equals("__")) {
            return result;
        }
        if (result.myNeedsToNotMatch.contains(result.myNeedsToMatch)) {
            return null;
        }
        result.myNeedsToNotMatch.clear();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedLocale that = (RestrictedLocale)o;
        if (this.myNeedsToMatch != null ? !this.myNeedsToMatch.equals(that.myNeedsToMatch) : that.myNeedsToMatch != null) {
            return false;
        }
        return this.myNeedsToNotMatch.equals(that.myNeedsToNotMatch);
    }

    public int hashCode() {
        int result = this.myNeedsToMatch != null ? this.myNeedsToMatch.hashCode() : 0;
        result = 31 * result + this.myNeedsToNotMatch.hashCode();
        return result;
    }
}

