/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceComponent
extends JPanel {
    public static final String NAME_LABEL = "Name Label";
    private final ResourceSwatchComponent myResourceSwatchComponent;
    private final JLabel myNameLabel = new JLabel();
    protected final JLabel myWarningLabel = new JLabel();
    private final VariantsComboBox myVariantCombo = new VariantsComboBox();

    public ResourceComponent(@NotNull Project project, boolean isEditor) {
        super(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP));
        this.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myWarningLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWarningLabel.setVisible(false);
        this.myNameLabel.setName(NAME_LABEL);
        this.myNameLabel.setForeground((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR);
        Box topRowPanel = new Box(2);
        topRowPanel.add(this.myNameLabel);
        topRowPanel.add(this.myWarningLabel);
        this.myVariantCombo.setVisible(false);
        topRowPanel.add(Box.createHorizontalGlue());
        topRowPanel.add(this.myVariantCombo);
        this.add((Component)topRowPanel, "Center");
        this.myResourceSwatchComponent = new ResourceSwatchComponent(project, isEditor);
        this.add((Component)this.myResourceSwatchComponent, "South");
        ThemeEditorUtils.setInheritsPopupMenuRecursive(this);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int firstRowHeight = Math.max(this.getFontMetrics(this.getFont()).getHeight(), this.myVariantCombo.getPreferredSize().height);
            int secondRowHeight = this.myResourceSwatchComponent.getPreferredSize().height;
            return new Dimension(0, ThemeEditorConstants.ATTRIBUTE_MARGIN + ThemeEditorConstants.ATTRIBUTE_ROW_GAP + firstRowHeight + secondRowHeight);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
    }

    public void setSwatchIcon(@NotNull ResourceSwatchComponent.SwatchIcon icon) {
        this.myResourceSwatchComponent.setSwatchIcon(icon);
    }

    public void setNameText(@NotNull String name) {
        this.myNameLabel.setText(name);
    }

    public void setWarning(@Nullable String warning) {
        if (!StringUtil.isEmpty((String)warning)) {
            this.myWarningLabel.setToolTipText(warning);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    public void setVariantsModel(@NotNull ComboBoxModel comboBoxModel) {
        this.myVariantCombo.setModel(comboBoxModel);
        this.myVariantCombo.setVisible(comboBoxModel.getSize() > 0);
    }

    public void addVariantItemListener(@NotNull ItemListener itemListener) {
        this.myVariantCombo.addItemListener(itemListener);
    }

    public void addVariantPopupClosingListener(@NotNull VariantsComboBox.PopupClosingListener listener) {
        this.myVariantCombo.addPopupClosingListener(listener);
    }

    public void setValueText(@NotNull String value) {
        this.myResourceSwatchComponent.setText(value);
    }

    @NotNull
    public String getValueText() {
        return this.myResourceSwatchComponent.getText();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myResourceSwatchComponent != null) {
            this.myResourceSwatchComponent.setFont(font);
        }
        if (this.myNameLabel != null) {
            this.myNameLabel.setFont(font);
        }
    }

    public void addSwatchListener(@NotNull ActionListener listener) {
        this.myResourceSwatchComponent.addSwatchListener(listener);
    }

    public void addTextListener(@NotNull ActionListener listener) {
        this.myResourceSwatchComponent.addTextListener(listener);
    }

    public void addTextDocumentListener(@NotNull DocumentListener listener) {
        this.myResourceSwatchComponent.addTextDocumentListener(listener);
    }

    public void addTextFocusListener(@NotNull FocusListener listener) {
        this.myResourceSwatchComponent.addTextFocusListener(listener);
    }

    public void setCompletionStrings(@NotNull List<String> completions) {
        this.myResourceSwatchComponent.setCompletionStrings(completions);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myWarningLabel.isVisible()) {
            this.validate();
            if (SwingUtilities.getLocalBounds(this.myWarningLabel).contains(SwingUtilities.convertMouseEvent(this, event, this.myWarningLabel).getPoint())) {
                return this.myWarningLabel.getToolTipText();
            }
        }
        return super.getToolTipText(event);
    }

    public Dimension getSwatchIconSize() {
        return new Dimension(this.myResourceSwatchComponent.getHeight(), this.myResourceSwatchComponent.getHeight());
    }

    @Nullable
    public ValidationInfo doValidate(int minApi, @NotNull AndroidTargetData androidTargetData) {
        return this.myResourceSwatchComponent.doValidate(minApi, androidTargetData);
    }
}

