/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace;

import com.android.tools.idea.editors.vmtrace.TraceViewPanel;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.android.tools.perflib.vmtrace.VmTraceHandler;
import com.android.tools.perflib.vmtrace.VmTraceParser;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VmTraceEditor
implements FileEditor {
    private final TraceViewPanel myTraceViewPanel;

    public VmTraceEditor(@NotNull Project project, @NotNull VirtualFile file) {
        this.myTraceViewPanel = new TraceViewPanel(project);
        this.parseTraceFileInBackground(project, file);
    }

    private void parseTraceFileInBackground(final @NotNull Project project, final @NotNull VirtualFile file) {
        final Task.Modal parseTask = new Task.Modal(project, "Parsing trace file", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                File traceFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                VmTraceData.Builder dataBuilder = new VmTraceData.Builder();
                VmTraceParser parser = new VmTraceParser(traceFile, (VmTraceHandler)dataBuilder);
                try {
                    parser.parse();
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)project, (String)("Unexpected error while parsing trace file: " + Throwables.getRootCause((Throwable)throwable).getMessage()), (String)VmTraceEditor.this.getName());
                        }
                    });
                    return;
                }
                final VmTraceData vmTraceData = dataBuilder.build();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VmTraceEditor.this.myTraceViewPanel.setTrace(vmTraceData);
                    }
                });
            }
        };
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                parseTask.queue();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        return this.myTraceViewPanel.getComponent();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "Traceview";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
    }
}

