/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs;

import com.android.tools.idea.experimental.codeanalysis.datastructs.ClassMember;
import com.android.tools.idea.experimental.codeanalysis.datastructs.Modifier;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCFGField
implements ClassMember,
PsiAnnotationOwner {
    protected PsiCFGClass mDeclearingClass;
    protected PsiField mPsiFieldRef;
    protected int modifierBits;

    public PsiCFGField(@NotNull PsiField field, @NotNull PsiCFGClass clazz) {
        this.mDeclearingClass = clazz;
        this.mPsiFieldRef = field;
        this.parseModifiers();
    }

    private void parseModifiers() {
        PsiModifierList modifierList = this.mPsiFieldRef.getModifierList();
        this.modifierBits = Modifier.ParseModifierList(modifierList);
    }

    public PsiField getPsiFieldRef() {
        return this.mPsiFieldRef;
    }

    @Override
    public PsiCFGClass getDeclaringClass() {
        return this.mDeclearingClass;
    }

    @Override
    public boolean isProtected() {
        return (this.modifierBits & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.modifierBits & 2) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.modifierBits & 1) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.modifierBits & 8) != 0;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        return new PsiAnnotation[0];
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return new PsiAnnotation[0];
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        return null;
    }
}

