/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.FutureCallbackExecutor;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.utils.FileUtils;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.swing.filechooser.FileSystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerFileManagerImpl
implements DeviceExplorerFileManager {
    private static final Logger LOGGER = Logger.getInstance(DeviceExplorerFileManagerImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<VirtualFile> myTemporaryEditorFiles = new ArrayList<VirtualFile>();
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @Nullable
    private Path myDefaultDownloadPath;

    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Executor edtExecutor) {
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerAdapter());
        this.myEdtExecutor = new FutureCallbackExecutor(edtExecutor);
    }

    public void setDefaultDownloadPath(@NotNull Path path) {
        this.myDefaultDownloadPath = path;
    }

    @NotNull
    public Path getDefaultLocalPathForDevice(@NotNull DeviceFileSystem device) {
        Path rootPath = this.getDefaultDownloadPath();
        return rootPath.resolve(DeviceExplorerFileManagerImpl.mapName(device.getName()));
    }

    @Override
    @NotNull
    public Path getDefaultLocalPathForEntry(@NotNull DeviceFileEntry entry) {
        Path devicePath = this.getDefaultLocalPathForDevice(entry.getFileSystem());
        Path relativePath = DeviceExplorerFileManagerImpl.getEntryPath(entry);
        return devicePath.resolve(relativePath);
    }

    @Override
    @NotNull
    public ListenableFuture<Void> downloadFileEntry(@NotNull DeviceFileEntry entry, final @NotNull Path localPath, @NotNull FileTransferProgress progress) {
        final SettableFuture futureResult = SettableFuture.create();
        try {
            FileUtils.mkdirs((File)localPath.getParent().toFile());
            FileUtils.deleteIfExists((File)localPath.toFile());
        }
        catch (IOException e) {
            futureResult.setException((Throwable)e);
            return futureResult;
        }
        ListenableFuture<Void> result = entry.downloadFile(localPath, progress);
        this.myEdtExecutor.addCallback(result, new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                futureResult.set(null);
            }

            public void onFailure(@NotNull Throwable t) {
                futureResult.setException(t);
                DeviceExplorerFileManagerImpl.this.deleteTemporaryFile(localPath);
            }
        });
        return futureResult;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> openFileInEditor(@NotNull Path localPath, boolean focusEditor) {
        return this.openFileInEditorWorker(localPath, focusEditor);
    }

    @NotNull
    private Path getDefaultDownloadPath() {
        if (this.myDefaultDownloadPath == null) {
            this.myDefaultDownloadPath = DeviceExplorerFileManagerImpl.getDefaultDownloadPathWorker();
        }
        return this.myDefaultDownloadPath;
    }

    @NotNull
    private static Path getDefaultDownloadPathWorker() {
        String userHome = System.getProperty("user.home");
        String path = null;
        if (SystemInfo.isWindows) {
            path = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        } else if (SystemInfo.isMac) {
            path = FileUtil.join((String[])new String[]{userHome, "Documents"});
        } else if (SystemInfo.isLinux) {
            path = userHome;
        }
        if (StringUtil.isEmpty((String)path)) {
            throw new RuntimeException("Platform is not supported");
        }
        path = FileUtil.join((String[])new String[]{path, "AndroidStudio", "DeviceExplorer"});
        return Paths.get(path, new String[0]);
    }

    @NotNull
    private static Path mapName(String name) {
        return Paths.get(PathUtilRt.suggestFileName((String)name, (boolean)true, (boolean)true), new String[0]);
    }

    @NotNull
    private static Path getEntryPath(@NotNull DeviceFileEntry file) {
        ArrayList<Path> names = new ArrayList<Path>();
        for (DeviceFileEntry entry = file; entry != null; entry = entry.getParent()) {
            names.add(DeviceExplorerFileManagerImpl.mapName(entry.getName()));
        }
        Collections.reverse(names);
        Optional path = names.stream().reduce(Path::resolve);
        assert (path.isPresent());
        return (Path)path.get();
    }

    private ListenableFuture<Void> openFileInEditorWorker(@NotNull Path localPath, boolean focusEditor) {
        SettableFuture futureFile = SettableFuture.create();
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            VirtualFile localFile = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (localFile == null) {
                futureFile.setException((Throwable)new RuntimeException(String.format("Unable to locate file \"%s\"", localPath)));
            } else {
                futureFile.set((Object)localFile);
            }
        });
        return this.myEdtExecutor.transform(futureFile, file -> {
            FileType type = FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, (Project)this.myProject);
            if (type == null) {
                throw new CancellationException("Operation cancelled by user");
            }
            FileEditor[] editors = FileEditorManager.getInstance((Project)this.myProject).openFile(file, focusEditor);
            if (editors.length == 0) {
                throw new RuntimeException(String.format("Unable to open file \"%s\" in editor", localPath));
            }
            this.myTemporaryEditorFiles.add((VirtualFile)file);
            return null;
        });
    }

    public void deleteTemporaryFile(@NotNull Path localPath) {
        try {
            Files.deleteIfExists(localPath);
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Error deleting device file from local file system \"%s\"", localPath), (Throwable)e);
        }
    }

    private class MyFileEditorManagerAdapter
    implements FileEditorManagerListener {
        private MyFileEditorManagerAdapter() {
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (DeviceExplorerFileManagerImpl.this.myTemporaryEditorFiles.contains(file)) {
                DeviceExplorerFileManagerImpl.this.myTemporaryEditorFiles.remove(file);
                Path localPath = Paths.get(file.getPath(), new String[0]);
                DeviceExplorerFileManagerImpl.this.deleteTemporaryFile(localPath);
            }
        }
    }
}

