/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.DeviceExplorerModelListener;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerModel {
    @NotNull
    private final List<DeviceExplorerModelListener> myListeners = new ArrayList<DeviceExplorerModelListener>();
    @NotNull
    private final List<DeviceFileSystem> myDevices = new ArrayList<DeviceFileSystem>();
    @Nullable
    private DeviceFileSystem myActiveDevice;
    @Nullable
    private DeviceState myActiveDeviceLastKnownState;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private DefaultTreeSelectionModel myTreeSelectionModel;

    @NotNull
    public List<DeviceFileSystem> getDevices() {
        return this.myDevices;
    }

    @Nullable
    public DeviceFileSystem getActiveDevice() {
        return this.myActiveDevice;
    }

    public void setActiveDevice(@Nullable DeviceFileSystem activeDevice) {
        this.myActiveDevice = activeDevice;
        this.myActiveDeviceLastKnownState = activeDevice == null ? null : activeDevice.getDeviceState();
        this.myListeners.forEach(x -> x.activeDeviceChanged(this.myActiveDevice));
        this.setActiveDeviceTreeModel(activeDevice, null, null);
    }

    @Nullable
    public DeviceState getActiveDeviceLastKnownState(@NotNull DeviceFileSystem device) {
        if (!Objects.equals(device, this.myActiveDevice)) {
            return null;
        }
        return this.myActiveDeviceLastKnownState;
    }

    public void setActiveDeviceLastKnownState(@NotNull DeviceFileSystem device) {
        if (!Objects.equals(device, this.myActiveDevice)) {
            return;
        }
        this.myActiveDeviceLastKnownState = device.getDeviceState();
    }

    @Nullable
    public DefaultTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @Nullable
    public DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.myTreeSelectionModel;
    }

    public void addListener(@NotNull DeviceExplorerModelListener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull DeviceExplorerModelListener listener) {
        this.myListeners.remove(listener);
    }

    public void setActiveDeviceTreeModel(@Nullable DeviceFileSystem device, @Nullable DefaultTreeModel treeModel, @Nullable DefaultTreeSelectionModel treeSelectionModel) {
        if (!Objects.equals(this.myActiveDevice, device)) {
            return;
        }
        if (Objects.equals(this.myTreeModel, treeModel)) {
            return;
        }
        this.myTreeModel = treeModel;
        this.myTreeSelectionModel = treeSelectionModel;
        this.myListeners.forEach(x -> x.treeModelChanged(treeModel, treeSelectionModel));
    }

    public void addDevice(@NotNull DeviceFileSystem device) {
        if (this.myDevices.contains(device)) {
            return;
        }
        this.myDevices.add(device);
        this.myListeners.forEach(l -> l.deviceAdded(device));
    }

    public void removeDevice(@NotNull DeviceFileSystem device) {
        if (!this.myDevices.contains(device)) {
            return;
        }
        this.myListeners.forEach(l -> l.deviceRemoved(device));
        this.myDevices.remove(device);
    }

    public void removeAllDevices() {
        this.myDevices.clear();
        this.setActiveDevice(null);
        this.setActiveDeviceTreeModel(null, null, null);
        this.myListeners.forEach(DeviceExplorerModelListener::allDevicesRemoved);
    }

    public void updateDevice(@NotNull DeviceFileSystem device) {
        if (!this.myDevices.contains(device)) {
            return;
        }
        this.myListeners.forEach(l -> l.deviceUpdated(device));
    }
}

