/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.FileTransferSummary;
import com.android.tools.idea.explorer.FileTransferWorkEstimate;
import com.android.tools.idea.explorer.FileTransferWorkEstimator;
import com.android.tools.idea.explorer.LongRunningOperationTracker;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.NotNull;

public class FileTransferOperationTracker
extends LongRunningOperationTracker {
    private static final int MAX_PATH_DISPLAY_LENGTH = 50;
    @NotNull
    private final FileTransferSummary mySummary = new FileTransferSummary();
    private long myFinishedWorkUnits;
    private long myTotalWorkUnits;
    private int myCurrentFileCount;
    private int myTotalFileCount;
    private int myCurrentDirectoryCount;
    private int myTotalDirectoryCount;

    public FileTransferOperationTracker(@NotNull DeviceExplorerView view) {
        super(view);
    }

    @NotNull
    public FileTransferSummary getSummary() {
        return this.mySummary;
    }

    @Override
    public void stop() {
        super.stop();
        this.mySummary.setDurationMillis(this.getDurationMillis());
    }

    public void addProblem(@NotNull Throwable error) {
        if (ExceptionUtil.getRootCause((Throwable)error) instanceof CancellationException) {
            return;
        }
        this.mySummary.getProblems().add(error);
        this.setWarningColor();
    }

    public void showProgress() {
        if (this.myTotalWorkUnits == 0L) {
            return;
        }
        this.setProgress((double)this.myFinishedWorkUnits / (double)this.myTotalWorkUnits);
    }

    public void processDirectory() {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getDirectoryWorkUnits();
        ++this.myCurrentDirectoryCount;
        this.showProgress();
    }

    public void processFile() {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getFileWorkUnits();
        ++this.myCurrentFileCount;
        this.showProgress();
    }

    public void processFileBytes(long byteCount) {
        this.myFinishedWorkUnits += FileTransferWorkEstimator.getFileContentsWorkUnits(byteCount);
        this.showProgress();
    }

    public void setUploadFileText(@NotNull VirtualFile file, long currentBytes, long totalBytes) {
        String text = this.myTotalFileCount > 1 ? String.format("Uploading file %,d of %,d: \"%s\"", this.myCurrentFileCount, this.myTotalFileCount, StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)50)) : String.format("Uploading file \"%s\"", StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)50));
        if (totalBytes > 0L) {
            text = text + String.format(" (%s / %s)", ApkViewPanel.getHumanizedSize(currentBytes), ApkViewPanel.getHumanizedSize(totalBytes));
        }
        this.setStatusText(text);
    }

    public void setDownloadFileText(@NotNull DeviceFileEntry entry, long currentBytes, long totalBytes) {
        String text = this.myTotalFileCount > 1 ? String.format("Downloading file %,d of %,d: \"%s\"", this.myCurrentFileCount, this.myTotalFileCount, StringUtil.shortenPathWithEllipsis((String)entry.getFullPath(), (int)50)) : String.format("Downloading file \"%s\"", StringUtil.shortenPathWithEllipsis((String)entry.getFullPath(), (int)50));
        if (totalBytes > 0L) {
            text = text + String.format(" (%s / %s)", ApkViewPanel.getHumanizedSize(currentBytes), ApkViewPanel.getHumanizedSize(totalBytes));
        }
        this.setStatusText(text);
    }

    public void addWorkEstimate(FileTransferWorkEstimate estimate) {
        this.myTotalFileCount += estimate.getFileCount();
        this.myTotalDirectoryCount += estimate.getDirectoryCount();
        this.myTotalWorkUnits += estimate.getWorkUnits();
    }

    public void setCalculatingText(int fileCount, int directoryCount) {
        String text = "Calculating...";
        if ((fileCount += this.myTotalFileCount) > 0 || (directoryCount += this.myTotalDirectoryCount) > 0) {
            text = text + String.format(" %,d %s, %,d %s", fileCount, StringUtil.pluralize((String)"file", (int)fileCount), directoryCount, StringUtil.pluralize((String)"directory", (int)directoryCount));
        }
        this.setStatusText(text);
    }
}

