/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.tools.idea.explorer.FileTransferWorkEstimate;
import com.android.tools.idea.explorer.FileTransferWorkEstimatorProgress;
import com.android.tools.idea.explorer.FutureCallbackExecutor;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.ThrottledProgress;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class FileTransferWorkEstimator {
    private static final int DIRECTORY_TRANSFER_WORK_UNITS = 64000;
    private static final int FILE_TRANSFER_WORK_UNITS = 64000;
    private static final int PROGRESS_REPORT_INTERVAL_MILLIS = 50;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final FutureCallbackExecutor myTaskExecutor;
    @NotNull
    private final ThrottledProgress myThrottledProgress;

    FileTransferWorkEstimator(@NotNull Executor edtExecutor, @NotNull Executor taskExecutor) {
        this.myEdtExecutor = FutureCallbackExecutor.wrap(edtExecutor);
        this.myTaskExecutor = FutureCallbackExecutor.wrap(taskExecutor);
        this.myThrottledProgress = new ThrottledProgress(50L);
    }

    public static long getDirectoryWorkUnits() {
        return 64000L;
    }

    public static long getFileWorkUnits() {
        return 64000L;
    }

    public static long getFileContentsWorkUnits(long byteCount) {
        return byteCount;
    }

    public ListenableFuture<FileTransferWorkEstimate> estimateDownloadWork(@NotNull DeviceFileEntry entry, boolean isLinkToDirectory, @NotNull FileTransferWorkEstimatorProgress progress) {
        FileTransferWorkEstimate workEstimate = new FileTransferWorkEstimate();
        ListenableFuture<Void> future = this.estimateDownloadWorkWorker(entry, isLinkToDirectory, workEstimate, progress);
        return this.myEdtExecutor.transform(future, aVoid -> workEstimate);
    }

    public ListenableFuture<Void> estimateDownloadWorkWorker(@NotNull DeviceFileEntry entry, boolean isLinkToDirectory, @NotNull FileTransferWorkEstimate estimate, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (progress.isCancelled()) {
            return Futures.immediateCancelledFuture();
        }
        this.reportProgress(estimate, progress);
        if (entry.isDirectory() || isLinkToDirectory) {
            ListenableFuture<List<DeviceFileEntry>> futureEntries = entry.getEntries();
            return this.myEdtExecutor.transformAsync(futureEntries, entries -> {
                assert (entries != null);
                estimate.addDirectoryCount(1);
                estimate.addWorkUnits(FileTransferWorkEstimator.getDirectoryWorkUnits());
                return this.myEdtExecutor.executeFuturesInSequence(entries.iterator(), childEntry -> this.estimateDownloadWorkWorker((DeviceFileEntry)childEntry, false, estimate, progress));
            });
        }
        estimate.addFileCount(1);
        estimate.addWorkUnits(FileTransferWorkEstimator.getFileWorkUnits() + FileTransferWorkEstimator.getFileContentsWorkUnits(entry.getSize()));
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<FileTransferWorkEstimate> estimateUploadWork(@NotNull Path path, @NotNull FileTransferWorkEstimatorProgress progress) {
        ListenableFuture<FileTransferWorkEstimate> futureEstimate = this.myTaskExecutor.executeAsync(() -> {
            FileTransferWorkEstimate workEstimate = new FileTransferWorkEstimate();
            if (!this.estimateUploadWorkWorker(path.toFile(), workEstimate, progress)) {
                return null;
            }
            return workEstimate;
        });
        return this.myTaskExecutor.transformAsync(futureEstimate, estimate -> {
            if (estimate == null) {
                return Futures.immediateCancelledFuture();
            }
            return Futures.immediateFuture((Object)estimate);
        });
    }

    private boolean estimateUploadWorkWorker(@NotNull File file, @NotNull FileTransferWorkEstimate estimate, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (progress.isCancelled()) {
            return false;
        }
        this.reportProgress(estimate, progress);
        if (file.isDirectory()) {
            estimate.addWorkUnits(FileTransferWorkEstimator.getDirectoryWorkUnits());
            estimate.addDirectoryCount(1);
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (this.estimateUploadWorkWorker(child, estimate, progress)) continue;
                    return false;
                }
            }
        } else {
            estimate.addWorkUnits(FileTransferWorkEstimator.getFileWorkUnits() + FileTransferWorkEstimator.getFileContentsWorkUnits(file.length()));
            estimate.addFileCount(1);
        }
        return true;
    }

    private void reportProgress(@NotNull FileTransferWorkEstimate estimate, @NotNull FileTransferWorkEstimatorProgress progress) {
        if (this.myThrottledProgress.check()) {
            int fileCount = estimate.getFileCount();
            int directoryCount = estimate.getDirectoryCount();
            this.myEdtExecutor.execute(() -> progress.progress(fileCount, directoryCount));
        }
    }
}

