/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.tools.idea.explorer.adbimpl.AdbDeviceDirectFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceForwardingFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntryBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.google.common.util.concurrent.ListenableFuture;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AdbDeviceDataDirectoryEntry
extends AdbDeviceForwardingFileEntry {
    @NotNull
    private final AdbDeviceDirectFileEntry myDirectEntry;

    public AdbDeviceDataDirectoryEntry(@NotNull AdbDeviceFileEntry entry) {
        super(entry.myDevice, entry.myEntry, entry.myParent);
        this.myDirectEntry = new AdbDeviceDirectFileEntry(entry.myDevice, entry.myEntry, entry.myParent, null);
    }

    @Override
    @NotNull
    public AdbDeviceFileEntry getForwardedFileEntry() {
        return this.myDirectEntry;
    }

    private static AdbFileListingEntry createDirectoryEntry(@NotNull AdbFileListingEntry parent, @NotNull String name) {
        return new AdbFileListingEntryBuilder(parent).setPath(AdbPathUtil.resolve(parent.getFullPath(), name)).build();
    }

    private static AdbFileListingEntry createFileEntry(@NotNull AdbFileListingEntry parent, @NotNull String name) {
        return new AdbFileListingEntryBuilder(parent).setPath(AdbPathUtil.resolve(parent.getFullPath(), name)).setKind(AdbFileListingEntry.EntryKind.FILE).setSize(-1L).build();
    }

    @Override
    @NotNull
    public ListenableFuture<List<DeviceFileEntry>> getEntries() {
        return this.myDevice.getTaskExecutor().executeAsync(() -> {
            ArrayList<AdbDeviceForwardingFileEntry> entries = new ArrayList<AdbDeviceForwardingFileEntry>();
            entries.add(new AdbDeviceDataAppDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "app")));
            entries.add(new AdbDeviceDataDataDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "data")));
            entries.add(new AdbDeviceDataLocalDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "local")));
            return entries;
        });
    }

    private static class AdbDevicePackageDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final String myPackageName;
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDevicePackageDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry, @NotNull String packageName) {
            super(parent.myDevice, entry, parent);
            this.myPackageName = packageName;
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, packageName);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            return this.myDirectEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            ListenableFuture<List<AdbFileListingEntry>> futureChildren = this.myDevice.getAdbFileListing().getChildrenRunAs(this.myEntry, this.myPackageName);
            return this.myDevice.getTaskExecutor().transform(futureChildren, entries -> {
                assert (entries != null);
                return entries.stream().map(x -> new AdbDevicePackageDirectoryEntry(this, (AdbFileListingEntry)x, this.myPackageName)).collect(Collectors.toList());
            });
        }

        @Override
        @NotNull
        public ListenableFuture<Void> downloadFile(@NotNull Path localPath, @NotNull FileTransferProgress progress) {
            return this.myDevice.getAdbFileTransfer().downloadFileViaTempLocation(this.getFullPath(), this.getSize(), localPath, progress, this.myPackageName);
        }

        @Override
        @NotNull
        public ListenableFuture<Void> uploadFile(@NotNull Path localPath, @NotNull String fileName, @NotNull FileTransferProgress progress) {
            return this.myDevice.getAdbFileTransfer().uploadFileViaTempLocation(localPath, AdbPathUtil.resolve(this.getFullPath(), fileName), progress, this.myPackageName);
        }
    }

    private static class AdbDeviceDataLocalDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDeviceDataLocalDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry) {
            super(parent.myDevice, entry, parent);
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, null);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            return this.myDirectEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            return this.myDevice.getTaskExecutor().executeAsync(() -> {
                ArrayList<AdbDeviceDirectFileEntry> entries = new ArrayList<AdbDeviceDirectFileEntry>();
                entries.add(new AdbDeviceDirectFileEntry(this.myDevice, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, "tmp"), this, null));
                return entries;
            });
        }
    }

    private static class AdbDeviceDataAppDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDeviceDataAppDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry) {
            super(parent.myDevice, entry, parent);
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, null);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            return this.myDirectEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            ListenableFuture<List<AdbFileOperations.PackageInfo>> futurePackages = this.myDevice.getAdbFileOperations().listPackageInfo();
            return this.myDevice.getTaskExecutor().transform(futurePackages, packages -> {
                assert (packages != null);
                return packages.stream().map(info -> {
                    List<String> segments = AdbPathUtil.getSegments(info.getPath());
                    if (segments.size() <= 2) {
                        return null;
                    }
                    if (!"data".equals(segments.get(0))) {
                        return null;
                    }
                    if (!"app".equals(segments.get(1))) {
                        return null;
                    }
                    if (segments.size() == 3) {
                        AdbFileListingEntry entry = AdbDeviceDataDirectoryEntry.createFileEntry(this.myEntry, segments.get(2));
                        return new AdbDeviceDirectFileEntry(this.myDevice, entry, this, info.getPackageName());
                    }
                    AdbFileListingEntry entry = AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, segments.get(2));
                    return new AdbDevicePackageDirectoryEntry(this, entry, info.getPackageName());
                }).filter(Objects::nonNull).collect(Collectors.toList());
            });
        }
    }

    private static class AdbDeviceDataDataDirectoryEntry
    extends AdbDeviceForwardingFileEntry {
        @NotNull
        private final AdbDeviceDirectFileEntry myDirectEntry;

        public AdbDeviceDataDataDirectoryEntry(@NotNull AdbDeviceFileEntry parent, @NotNull AdbFileListingEntry entry) {
            super(parent.myDevice, entry, parent);
            this.myDirectEntry = new AdbDeviceDirectFileEntry(parent.myDevice, entry, parent, null);
        }

        @Override
        @NotNull
        public AdbDeviceFileEntry getForwardedFileEntry() {
            return this.myDirectEntry;
        }

        @Override
        @NotNull
        public ListenableFuture<List<DeviceFileEntry>> getEntries() {
            ListenableFuture<List<String>> futurePackages = this.myDevice.getAdbFileOperations().listPackages();
            return this.myDevice.getTaskExecutor().transform(futurePackages, packages -> {
                assert (packages != null);
                return packages.stream().map(packageName -> new AdbDevicePackageDirectoryEntry(this, AdbDeviceDataDirectoryEntry.createDirectoryEntry(this.myEntry, packageName), (String)packageName)).collect(Collectors.toList());
            });
        }
    }
}

