/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.explorer.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceCapabilities;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDataDirectoryEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDefaultFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceDirectFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileEntry;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.adbimpl.AdbFileListing;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileOperations;
import com.android.tools.idea.explorer.adbimpl.AdbFileTransfer;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceState;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class AdbDeviceFileSystem
implements DeviceFileSystem {
    @NotNull
    private final AdbDeviceFileSystemService myService;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final AdbDeviceCapabilities myDeviceCapabilities;
    @NotNull
    private final AdbFileListing myFileListing;
    @NotNull
    private final AdbFileOperations myFileOperations;
    @NotNull
    private final AdbFileTransfer myFileTransfer;

    public AdbDeviceFileSystem(@NotNull AdbDeviceFileSystemService service, @NotNull IDevice device) {
        this.myService = service;
        this.myDevice = device;
        this.myDeviceCapabilities = new AdbDeviceCapabilities(this.myDevice);
        this.myFileListing = new AdbFileListing(this.myDevice, this.myDeviceCapabilities, service.getTaskExecutor());
        this.myFileOperations = new AdbFileOperations(this.myDevice, this.myDeviceCapabilities, service.getTaskExecutor());
        this.myFileTransfer = new AdbFileTransfer(this.myDevice, this.myFileOperations, service.getEdtExecutor(), service.getTaskExecutor());
    }

    boolean isDevice(@Nullable IDevice device) {
        return this.myDevice.equals(device);
    }

    @NotNull
    IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    public AdbDeviceCapabilities getCapabilities() {
        return this.myDeviceCapabilities;
    }

    @NotNull
    public AdbFileListing getAdbFileListing() {
        return this.myFileListing;
    }

    @NotNull
    public AdbFileOperations getAdbFileOperations() {
        return this.myFileOperations;
    }

    @NotNull
    public AdbFileTransfer getAdbFileTransfer() {
        return this.myFileTransfer;
    }

    @NotNull
    FutureCallbackExecutor getTaskExecutor() {
        return this.myService.getTaskExecutor();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myDevice.getName();
    }

    @Override
    @NotNull
    public DeviceState getDeviceState() {
        switch (this.myDevice.getState()) {
            case ONLINE: {
                return DeviceState.ONLINE;
            }
            case OFFLINE: {
                return DeviceState.OFFLINE;
            }
            case UNAUTHORIZED: {
                return DeviceState.UNAUTHORIZED;
            }
            case DISCONNECTED: {
                return DeviceState.DISCONNECTED;
            }
            case BOOTLOADER: {
                return DeviceState.BOOTLOADER;
            }
            case RECOVERY: {
                return DeviceState.RECOVERY;
            }
            case SIDELOAD: {
                return DeviceState.SIDELOAD;
            }
        }
        return DeviceState.DISCONNECTED;
    }

    @Override
    @NotNull
    public ListenableFuture<DeviceFileEntry> getRootDirectory() {
        return this.getTaskExecutor().transform(this.getAdbFileListing().getRoot(), entry -> {
            assert (entry != null);
            return new AdbDeviceDefaultFileEntry(this, (AdbFileListingEntry)entry, null);
        });
    }

    @Override
    @NotNull
    public ListenableFuture<DeviceFileEntry> getEntry(final @NotNull String path) {
        final SettableFuture resultFuture = SettableFuture.create();
        ListenableFuture<DeviceFileEntry> currentDir = this.getRootDirectory();
        this.getTaskExecutor().addCallback(currentDir, new FutureCallback<DeviceFileEntry>(){

            public void onSuccess(@Nullable DeviceFileEntry result) {
                assert (result != null);
                if (StringUtil.isEmpty((String)path) || StringUtil.equals((CharSequence)path, (CharSequence)"/")) {
                    resultFuture.set((Object)result);
                    return;
                }
                String[] pathSegments = path.substring(1).split("/");
                AdbDeviceFileSystem.this.resolvePathSegments((SettableFuture<DeviceFileEntry>)resultFuture, result, pathSegments, 0);
            }

            public void onFailure(@NotNull Throwable t) {
                resultFuture.setException(t);
            }
        });
        return resultFuture;
    }

    private void resolvePathSegments(final @NotNull SettableFuture<DeviceFileEntry> future, @NotNull DeviceFileEntry currentEntry, final @NotNull String[] segments, final int segmentIndex) {
        if (segmentIndex >= segments.length) {
            future.set((Object)currentEntry);
            return;
        }
        ListenableFuture<List<DeviceFileEntry>> entriesFuture = currentEntry.getEntries();
        this.getTaskExecutor().addCallback(entriesFuture, new FutureCallback<List<DeviceFileEntry>>(){

            public void onSuccess(@Nullable List<DeviceFileEntry> result) {
                assert (result != null);
                Optional<DeviceFileEntry> entry = result.stream().filter(x -> x.getName().equals(segments[segmentIndex])).findFirst();
                if (!entry.isPresent()) {
                    future.setException((Throwable)new IllegalArgumentException("Path not found"));
                } else {
                    AdbDeviceFileSystem.this.resolvePathSegments((SettableFuture<DeviceFileEntry>)future, entry.get(), segments, segmentIndex + 1);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                future.setException(t);
            }
        });
    }

    @NotNull
    public ListenableFuture<AdbDeviceFileEntry> resolveMountPoint(@NotNull AdbDeviceFileEntry entry) {
        return this.getTaskExecutor().executeAsync(() -> {
            if (this.myDeviceCapabilities.supportsSuRootCommand() || this.myDeviceCapabilities.isRoot()) {
                return AdbDeviceFileSystem.createDirectFileEntry(entry);
            }
            if (Objects.equals(entry.getFullPath(), "/data")) {
                return new AdbDeviceDataDirectoryEntry(entry);
            }
            return AdbDeviceFileSystem.createDirectFileEntry(entry);
        });
    }

    @NotNull
    private static AdbDeviceDirectFileEntry createDirectFileEntry(@NotNull AdbDeviceFileEntry entry) {
        return new AdbDeviceDirectFileEntry(entry.myDevice, entry.myEntry, entry.myParent, null);
    }
}

