/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystem;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemRenderer;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class AdbDeviceFileSystemRenderer
implements DeviceFileSystemRenderer {
    @NotNull
    private AdbDeviceFileSystemService myService;
    @NotNull
    private final DeviceNameRenderer myDeviceNameRenderer;

    public AdbDeviceFileSystemRenderer(@NotNull AdbDeviceFileSystemService service) {
        this.myService = service;
        this.myDeviceNameRenderer = new DeviceNameRenderer();
    }

    @Override
    @NotNull
    public ListCellRenderer<DeviceFileSystem> getDeviceNameListRenderer() {
        return this.myDeviceNameRenderer;
    }

    private class DeviceNameRenderer
    implements ListCellRenderer<DeviceFileSystem> {
        private final DeviceRenderer.DeviceComboBoxRenderer myRendererImpl = new DeviceRenderer.DeviceComboBoxRenderer("No Connected Devices", false);

        @Override
        public Component getListCellRendererComponent(JList<? extends DeviceFileSystem> list, DeviceFileSystem value, int index, boolean isSelected, boolean cellHasFocus) {
            List<IDevice> deviceList = AdbDeviceFileSystemRenderer.this.myService.getDeviceList().stream().map(x -> ((AdbDeviceFileSystem)x).getDevice()).collect(Collectors.toList());
            this.myRendererImpl.setShowSerial(DeviceRenderer.shouldShowSerialNumbers(deviceList));
            IDevice device = value == null ? null : ((AdbDeviceFileSystem)value).getDevice();
            return this.myRendererImpl.getListCellRendererComponent(list, device, index, isSelected, cellHasFocus);
        }
    }
}

