/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer.adbimpl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.explorer.FutureCallbackExecutor;
import com.android.tools.idea.explorer.adbimpl.AdbDeviceCapabilities;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntry;
import com.android.tools.idea.explorer.adbimpl.AdbFileListingEntryBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandBuilder;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandResult;
import com.android.tools.idea.explorer.adbimpl.AdbShellCommandsUtil;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileListing {
    @NotNull
    public static final Logger LOGGER = Logger.getInstance(AdbFileListing.class);
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private AdbDeviceCapabilities myDeviceCapabilities;
    @NotNull
    private final FutureCallbackExecutor myExecutor;
    @NotNull
    private final AdbFileListingEntry myRoot;

    public AdbFileListing(@NotNull IDevice device, @NotNull AdbDeviceCapabilities deviceCapabilities, @NotNull Executor taskExecutor) {
        this.myDevice = device;
        this.myDeviceCapabilities = deviceCapabilities;
        this.myExecutor = FutureCallbackExecutor.wrap(taskExecutor);
        this.myRoot = new AdbFileListingEntryBuilder().setPath("/").setKind(AdbFileListingEntry.EntryKind.DIRECTORY).build();
    }

    @NotNull
    public ListenableFuture<AdbFileListingEntry> getRoot() {
        return Futures.immediateFuture((Object)this.myRoot);
    }

    @NotNull
    public ListenableFuture<List<AdbFileListingEntry>> getChildren(@NotNull AdbFileListingEntry parentEntry) {
        return this.getChildrenRunAs(parentEntry, null);
    }

    @NotNull
    public ListenableFuture<List<AdbFileListingEntry>> getChildrenRunAs(@NotNull AdbFileListingEntry parentEntry, @Nullable String runAs) {
        return this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(runAs, "ls -l ").withDirectoryEscapedPath(parentEntry.getFullPath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommand(this.myDevice, command);
            List entries = commandResult.getOutput().stream().map(x -> AdbFileListing.processLsOutputLine(parentEntry, x)).filter(Objects::nonNull).collect(Collectors.toList());
            if (entries.isEmpty() && commandResult.isError()) {
                commandResult.throwIfError();
            }
            return entries;
        });
    }

    @NotNull
    public ListenableFuture<Boolean> isDirectoryLink(@NotNull AdbFileListingEntry entry) {
        return this.isDirectoryLinkRunAs(entry, null);
    }

    @NotNull
    public ListenableFuture<Boolean> isDirectoryLinkRunAs(@NotNull AdbFileListingEntry entry, @Nullable String runAs) {
        if (!entry.isSymbolicLink()) {
            return Futures.immediateFuture((Object)false);
        }
        return this.myExecutor.executeAsync(() -> {
            String command = this.getCommand(runAs, "ls -l -d ").withDirectoryEscapedPath(entry.getFullPath()).build();
            AdbShellCommandResult commandResult = AdbShellCommandsUtil.executeCommandNoErrorCheck(this.myDevice, command);
            int lineCount = 0;
            for (String line : commandResult.getOutput()) {
                Matcher m = FileListingService.LS_LD_PATTERN.matcher(line);
                if (!m.matches()) continue;
                if (lineCount > 0) {
                    LOGGER.warn(String.format("Unexpected additional output line matching result of ld -l -d: %s", line));
                }
                ++lineCount;
            }
            return lineCount > 0;
        });
    }

    @Nullable
    private static AdbFileListingEntry processLsOutputLine(@NotNull AdbFileListingEntry parentEntry, @NotNull String line) {
        if (line.isEmpty()) {
            return null;
        }
        Matcher m = FileListingService.LS_L_PATTERN.matcher(line);
        if (!m.matches()) {
            return null;
        }
        String name = m.group(7);
        String permissions = m.group(1);
        String owner = m.group(2);
        String group = m.group(3);
        String size = m.group(4);
        String date = m.group(5);
        String time2 = m.group(6);
        String info = null;
        AdbFileListingEntry.EntryKind objectType = AdbFileListingEntry.EntryKind.OTHER;
        switch (permissions.charAt(0)) {
            case '-': {
                objectType = AdbFileListingEntry.EntryKind.FILE;
                break;
            }
            case 'b': {
                objectType = AdbFileListingEntry.EntryKind.BLOCK;
                break;
            }
            case 'c': {
                objectType = AdbFileListingEntry.EntryKind.CHARACTER;
                break;
            }
            case 'd': {
                objectType = AdbFileListingEntry.EntryKind.DIRECTORY;
                break;
            }
            case 'l': {
                objectType = AdbFileListingEntry.EntryKind.SYMBOLIC_LINK;
                break;
            }
            case 's': {
                objectType = AdbFileListingEntry.EntryKind.SOCKET;
                break;
            }
            case 'p': {
                objectType = AdbFileListingEntry.EntryKind.FIFO;
            }
        }
        if (objectType == AdbFileListingEntry.EntryKind.SYMBOLIC_LINK) {
            String[] segments = name.split("\\s->\\s");
            if (segments.length == 2) {
                name = segments[0];
                info = segments[1];
            }
            info = "-> " + info;
        }
        String path = AdbPathUtil.resolve(parentEntry.getFullPath(), name);
        return new AdbFileListingEntry(path, objectType, permissions, owner, group, date, time2, size, info);
    }

    @NotNull
    private AdbShellCommandBuilder getCommand(@Nullable String runAs, @NotNull String text) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        AdbShellCommandBuilder command = new AdbShellCommandBuilder();
        if (runAs != null) {
            command.withRunAs(runAs);
        } else if (this.myDeviceCapabilities.supportsSuRootCommand()) {
            command.withSuRootPrefix();
        }
        return command.withText(text);
    }
}

