/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.fd.InstantRunBuildProgressListener;
import com.android.tools.idea.fd.LogcatRecorder;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class FlightRecorder {
    private static final String FD_FLR_LOGS = "flr";
    private static final String FN_GRADLE_LOG = "build.log";
    private static final String FN_GRADLE_PROFILE = "profile.log";
    private static final String FN_BUILD_INFO = "build-info.xml";
    private static final int MAX_LOG_ENTRY_COUNT = 10;
    private final Path myBasePath;
    private final LogcatRecorder myLogcatRecorder;
    private LocalDateTime myTimestamp;

    public static FlightRecorder get(@NotNull Project project) {
        return (FlightRecorder)ServiceManager.getService((Project)project, FlightRecorder.class);
    }

    private FlightRecorder(@NotNull Project project) {
        Path logs = Paths.get(PathManager.getLogPath(), new String[0]);
        Path flr = Paths.get(FD_FLR_LOGS, project.getLocationHash());
        this.myBasePath = logs.resolve(flr);
        this.myLogcatRecorder = new LogcatRecorder(AndroidLogcatService.getInstance());
        this.myTimestamp = FlightRecorder.now();
    }

    public void saveBuildOutput(@NotNull String gradleOutput, @NotNull InstantRunBuildProgressListener instantRunProgressListener) {
        this.myTimestamp = FlightRecorder.now();
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new BuildOutputRecorderTask(this.myBasePath, this.myTimestamp, gradleOutput, instantRunProgressListener));
    }

    public void saveBuildInfo(@NotNull InstantRunBuildInfo instantRunBuildInfo) {
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new BuildInfoRecorderTask(this.myBasePath, this.myTimestamp, instantRunBuildInfo));
    }

    public void setLaunchTarget(@NotNull AndroidDevice device) {
        try {
            Path deviceLog = this.myBasePath.resolve(FlightRecorder.timeStampToFolder(this.myTimestamp)).resolve(FlightRecorder.getDeviceLogFileName(device));
            Files.write(deviceLog, new byte[0], new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.getInstance(FlightRecorder.class).info("Unable to record deployment device info", (Throwable)e);
        }
        if (device.getLaunchedDevice().isDone()) {
            try {
                IDevice d = (IDevice)device.getLaunchedDevice().get();
                this.myLogcatRecorder.startMonitoring(d, this.myTimestamp);
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.getInstance(FlightRecorder.class).info("Unable to start recording logcat", (Throwable)e);
            }
        }
    }

    private static String getDeviceLogFileName(@NotNull AndroidDevice device) {
        IDevice d;
        if (device.isVirtual()) {
            return "TARGET-AVD";
        }
        ListenableFuture<IDevice> launchedDevice = device.getLaunchedDevice();
        if (!launchedDevice.isDone()) {
            return "OFFLINE";
        }
        try {
            d = (IDevice)launchedDevice.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return "OFFLINE";
        }
        return DevicePropertyUtil.getManufacturer(d, "unknown").replace(' ', '.') + '-' + DevicePropertyUtil.getModel(d, "unknown").replace(' ', '.');
    }

    @NotNull
    private static LocalDateTime now() {
        return LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    @NotNull
    static String timeStampToFolder(@NotNull LocalDateTime dateTime) {
        return dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replace(':', '.');
    }

    @NotNull
    static LocalDateTime folderToTimeStamp(@NotNull Path path) {
        String fileName = path.getFileName().toString();
        return LocalDateTime.parse(fileName.replace('.', ':'));
    }

    static void trimOldLogs(@NotNull Path root, int count) {
        ArrayList allLogs;
        DirectoryStream.Filter<Path> filter = entry -> {
            if (!Files.isDirectory(entry, new LinkOption[0])) {
                return false;
            }
            try {
                FlightRecorder.folderToTimeStamp(entry);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, filter);){
            allLogs = Lists.newArrayList(stream.iterator());
        }
        catch (IOException e) {
            Logger.getInstance(FlightRecorder.class).warn("Unable to cleanup flight recorder logs", (Throwable)e);
            return;
        }
        allLogs.stream().sorted((p1, p2) -> FlightRecorder.folderToTimeStamp(p2).compareTo(FlightRecorder.folderToTimeStamp(p1))).skip(count).forEach(path -> {
            try {
                FileUtils.deleteDirectoryContents((File)path.toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @NotNull
    public List<Path> getAllLogs() {
        ArrayList<Path> logs = new ArrayList<Path>();
        Path logsHome = Paths.get(PathManager.getLogPath(), new String[0]);
        if (logsHome == null) {
            return logs;
        }
        logs.addAll(FlightRecorder.getIdeaLogs(logsHome));
        logs.addAll(this.getFlightRecorderLogs());
        Path logcatPath = logsHome.resolve("logcat.txt");
        try {
            Files.write(logcatPath, this.myLogcatRecorder.getLogs(), Charsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            logs.add(logcatPath);
        }
        catch (IOException e) {
            Logger.getInstance(FlightRecorder.class).info("Unexpected error saving logcat", (Throwable)e);
        }
        return logs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static List<Path> getIdeaLogs(@NotNull Path logsHome) {
        try (Stream<Path> stream = Files.list(logsHome);){
            List<Path> list = stream.filter(p -> Files.isReadable(p) && p.getFileName().toString().startsWith("idea.log")).sorted((p1, p2) -> Long.compare(p2.toFile().lastModified(), p1.toFile().lastModified())).limit(3L).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }

    @NotNull
    private List<Path> getFlightRecorderLogs() {
        try {
            final ArrayList<Path> list = new ArrayList<Path>(100);
            Files.walkFileTree(this.myBasePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path fileName = file.getFileName();
                    if (fileName != null && fileName.toString().startsWith(".")) {
                        return FileVisitResult.CONTINUE;
                    }
                    list.add(file);
                    return list.size() > 100 ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                }
            });
            return list;
        }
        catch (IOException e) {
            return ImmutableList.of();
        }
    }

    @NotNull
    public String getPresentablePath(@NotNull Path file) {
        if (file.startsWith(this.myBasePath)) {
            return this.myBasePath.relativize(file).toString();
        }
        return file.getFileName().toString();
    }

    private static class BuildInfoRecorderTask
    implements Runnable {
        private final Path myBasePath;
        private final InstantRunBuildInfo myBuildInfo;

        public BuildInfoRecorderTask(Path logsRoot, LocalDateTime dateTime, InstantRunBuildInfo instantRunBuildInfo) {
            this.myBasePath = logsRoot.resolve(FlightRecorder.timeStampToFolder(dateTime));
            this.myBuildInfo = instantRunBuildInfo;
        }

        @Override
        public void run() {
            try {
                Files.createDirectories(this.myBasePath, new FileAttribute[0]);
                try (BufferedWriter bw = Files.newBufferedWriter(this.myBasePath.resolve(FlightRecorder.FN_BUILD_INFO), Charsets.UTF_8, new OpenOption[0]);){
                    this.myBuildInfo.serializeTo((Writer)bw);
                }
            }
            catch (IOException e) {
                Logger.getInstance(FlightRecorder.class).info("Unable to build info", (Throwable)e);
            }
        }
    }

    private static class BuildOutputRecorderTask
    implements Runnable {
        private final Path myLogsRoot;
        private final Path myCurrentLogPath;
        private final String myGradleOutput;
        private final InstantRunBuildProgressListener myBuildProgressListener;

        private BuildOutputRecorderTask(@NotNull Path logsRoot, @NotNull LocalDateTime dateTime, @NotNull String gradleOuput, @NotNull InstantRunBuildProgressListener buildProgressListener) {
            this.myLogsRoot = logsRoot;
            this.myCurrentLogPath = logsRoot.resolve(FlightRecorder.timeStampToFolder(dateTime));
            this.myGradleOutput = gradleOuput;
            this.myBuildProgressListener = buildProgressListener;
        }

        @Override
        public void run() {
            this.saveCurrentLog();
            FlightRecorder.trimOldLogs(this.myLogsRoot, 10);
        }

        private void saveCurrentLog() {
            try {
                Files.createDirectories(this.myCurrentLogPath, new FileAttribute[0]);
                Files.write(this.myCurrentLogPath.resolve(FlightRecorder.FN_GRADLE_LOG), this.myGradleOutput.getBytes(Charsets.UTF_8), new OpenOption[0]);
                try (BufferedWriter bw = Files.newBufferedWriter(this.myCurrentLogPath.resolve(FlightRecorder.FN_GRADLE_PROFILE), Charsets.UTF_8, new OpenOption[0]);){
                    this.myBuildProgressListener.serializeTo(bw);
                }
            }
            catch (IOException e) {
                Logger.getInstance(FlightRecorder.class).info("Unable to save gradle output logs", (Throwable)e);
            }
        }
    }
}

