/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.diagnostics.crash.CrashReporter;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunNotificationProvider;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.DeployApkTask;
import com.android.tools.idea.run.tasks.HotSwapTask;
import com.android.tools.idea.run.tasks.InstantRunNotificationTask;
import com.android.tools.idea.run.tasks.KillTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.NoChangesTask;
import com.android.tools.idea.run.tasks.SplitApkDeployTask;
import com.android.tools.idea.run.tasks.UpdateAppInfoTask;
import com.android.tools.idea.run.tasks.UpdateInstantRunStateTask;
import com.android.tools.ir.client.InstantRunArtifact;
import com.android.tools.ir.client.InstantRunArtifactType;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.internal.statistic.StatisticsUploadAssistant;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuildAnalyzer {
    private final Project myProject;
    private final InstantRunContext myContext;
    private final ProcessHandler myCurrentSession;
    private final InstantRunBuildInfo myBuildInfo;
    private final boolean myIsRestartActivity;
    private final Collection<ApkInfo> myApks;

    public InstantRunBuildAnalyzer(@NotNull Project project, @NotNull InstantRunContext context, @Nullable ProcessHandler currentSession, boolean isRestartActivity) {
        this(project, context, currentSession, Collections.EMPTY_LIST, isRestartActivity);
    }

    public InstantRunBuildAnalyzer(@NotNull Project project, @NotNull InstantRunContext context, @Nullable ProcessHandler currentSession, @NotNull Collection<ApkInfo> apks, boolean isRestartActivity) {
        this.myProject = project;
        this.myContext = context;
        this.myCurrentSession = currentSession;
        this.myApks = apks;
        this.myIsRestartActivity = isRestartActivity;
        this.myBuildInfo = this.myContext.getInstantRunBuildInfo();
        if (this.myBuildInfo == null) {
            throw new IllegalArgumentException("Instant Run Build Information must be available post build");
        }
        if (!this.myBuildInfo.isCompatibleFormat()) {
            throw new IllegalStateException("This version of Android Studio is incompatible with the Gradle Plugin used. Try disabling Instant Run (or updating either the IDE or the Gradle plugin to the latest version)");
        }
    }

    public boolean canReuseProcessHandler() {
        if (this.myCurrentSession == null || this.myCurrentSession.isProcessTerminated()) {
            return false;
        }
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        assert (buildSelection != null) : "Build must have completed before results are analyzed";
        return buildSelection.getBuildMode() == BuildMode.HOT && this.myBuildInfo.getBuildMode().equals("HOT_WARM");
    }

    @NotNull
    public List<LaunchTask> getDeployTasks(@NotNull LaunchOptions launchOptions) {
        UpdateInstantRunStateTask updateStateTask = new UpdateInstantRunStateTask(this.myContext);
        DeployType deployType = this.getDeployType();
        switch (deployType) {
            case NO_CHANGES: {
                return ImmutableList.of((Object)new NoChangesTask(this.myProject, this.myContext), (Object)updateStateTask);
            }
            case RESTART: {
                return ImmutableList.of((Object)new KillTask(this.myProject, this.myContext), (Object)updateStateTask);
            }
            case HOTSWAP: 
            case WARMSWAP: {
                ImmutableList.Builder taskBuilder = new ImmutableList.Builder();
                if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT})) {
                    taskBuilder.add((Object)new SplitApkDeployTask(this.myProject, this.myContext, true));
                    taskBuilder.add((Object)new UpdateAppInfoTask(this.myProject, this.myContext));
                }
                if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.RELOAD_DEX}) || this.myBuildInfo.hasHotSwapResources()) {
                    taskBuilder.add((Object)new HotSwapTask(this.myProject, this.myContext, deployType == DeployType.WARMSWAP));
                }
                return taskBuilder.add((Object)updateStateTask).build();
            }
            case SPLITAPK: {
                return ImmutableList.of((Object)new SplitApkDeployTask(this.myProject, this.myContext), (Object)updateStateTask);
            }
            case FULLAPK: 
            case LEGACY: {
                return ImmutableList.of((Object)new DeployApkTask(this.myProject, launchOptions, this.myApks, this.myContext));
            }
        }
        if (StatisticsUploadAssistant.isSendAllowed()) {
            CrashReporter.getInstance().submit(this.getIrDebugSignals(deployType));
        }
        throw new IllegalStateException(AndroidBundle.message("instant.run.build.error", new Object[0]));
    }

    @NotNull
    private Map<String, String> getIrDebugSignals(@NotNull DeployType deployType) {
        InstantRunBuildInfo buildInfo;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("deployType", deployType.toString());
        m.put("canReuseProcessHandler", Boolean.toString(this.canReuseProcessHandler()));
        m.put("androidGradlePluginVersion", this.myContext.getGradlePluginVersion().toString());
        BuildSelection selection = this.myContext.getBuildSelection();
        if (selection != null) {
            m.put("buildSelection.mode", selection.getBuildMode().toString());
            m.put("buildSelection.why", selection.why.toString());
        }
        if ((buildInfo = this.myContext.getInstantRunBuildInfo()) != null) {
            m.put("buildinfo.buildMode", buildInfo.getBuildMode());
            m.put("buildinfo.verifierStatus", buildInfo.getVerifierStatus());
            m.put("buildinfo.format", Integer.toString(buildInfo.getFormat()));
            List artifacts = buildInfo.getArtifacts();
            m.put("buildinfo.nArtifacts", Integer.toString(artifacts.size()));
            for (int i = 0; i < artifacts.size(); ++i) {
                InstantRunArtifact artifact = (InstantRunArtifact)artifacts.get(i);
                String prefix = "buildInfo.artifact[" + i + "]";
                m.put(prefix + ".type", artifact.type.toString());
                m.put(prefix + ".file", artifact.file.getName());
            }
        }
        return m;
    }

    @NotNull
    public LaunchTask getNotificationTask() {
        DeployType deployType = this.getDeployType();
        BuildSelection buildSelection = this.myContext.getBuildSelection();
        InstantRunNotificationProvider notificationProvider = new InstantRunNotificationProvider(buildSelection, deployType, this.myBuildInfo.getVerifierStatus());
        return new InstantRunNotificationTask(this.myProject, this.myContext, notificationProvider, buildSelection);
    }

    @NotNull
    DeployType getDeployType() {
        List artifacts;
        if (this.canReuseProcessHandler()) {
            if (this.myBuildInfo.hasNoChanges()) {
                return DeployType.NO_CHANGES;
            }
            if (this.myBuildInfo.canHotswap()) {
                return this.myIsRestartActivity ? DeployType.WARMSWAP : DeployType.HOTSWAP;
            }
        }
        if ((artifacts = this.myBuildInfo.getArtifacts()).isEmpty()) {
            if (this.myBuildInfo.getVerifierStatus().equals(DeployType.NO_CHANGES.toString())) {
                return DeployType.NO_CHANGES;
            }
            return DeployType.RESTART;
        }
        if (this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT}) || this.myBuildInfo.hasOneOf(new InstantRunArtifactType[]{InstantRunArtifactType.SPLIT_MAIN})) {
            return DeployType.SPLITAPK;
        }
        return DeployType.FULLAPK;
    }
}

