/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.annotations.NotNull;

public class InstantRunBuildProgressListener
implements ProgressListener {
    private final List<ProgressEvent> myEvents = new ArrayList<ProgressEvent>(512);

    public void statusChanged(ProgressEvent event) {
        this.myEvents.add(event);
    }

    public void serializeTo(@NotNull Writer writer) throws IOException {
        if (this.myEvents.isEmpty()) {
            writer.append("No events");
            return;
        }
        long startTime = this.myEvents.get(0).getEventTime();
        for (ProgressEvent event : this.myEvents) {
            writer.append(String.format(Locale.US, "%10d", event.getEventTime() - startTime));
            writer.append(' ');
            writer.append(event.toString());
            writer.append('\n');
        }
    }
}

