/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.builder.model.OptionalCompilationStep;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildMode;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunTasksProvider;
import com.android.tools.idea.gradle.run.BeforeRunBuilder;
import com.android.tools.idea.gradle.run.GradleTaskRunner;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.util.MultiUserUtils;
import com.android.tools.ir.client.AppState;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.android.tools.ir.client.InstantRunClient;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunBuilder
implements BeforeRunBuilder {
    private static final Logger LOG = Logger.getInstance(InstantRunBuilder.class);
    @Nullable
    private final IDevice myDevice;
    private final InstantRunContext myInstantRunContext;
    private final AndroidRunConfigContext myRunContext;
    private final InstantRunTasksProvider myTasksProvider;
    private final InstalledApkCache myInstalledApkCache;
    private final InstantRunClientDelegate myInstantRunClientDelegate;
    private final boolean myFlightRecorderEnabled;

    public InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider) {
        this(device, instantRunContext, runConfigContext, tasksProvider, InstantRunSettings.isRecorderEnabled(), (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), new InstantRunClientDelegate(){});
    }

    InstantRunBuilder(@Nullable IDevice device, @NotNull InstantRunContext instantRunContext, @NotNull AndroidRunConfigContext runConfigContext, @NotNull InstantRunTasksProvider tasksProvider, boolean enableFlightRecorder, @NotNull InstalledApkCache installedApkCache, @NotNull InstantRunClientDelegate delegate) {
        this.myDevice = device;
        this.myInstantRunContext = instantRunContext;
        this.myRunContext = runConfigContext;
        this.myTasksProvider = tasksProvider;
        this.myFlightRecorderEnabled = enableFlightRecorder;
        this.myInstalledApkCache = installedApkCache;
        this.myInstantRunClientDelegate = delegate;
    }

    @Override
    public boolean build(@NotNull GradleTaskRunner taskRunner, @NotNull List<String> commandLineArguments) throws InterruptedException, InvocationTargetException {
        BuildSelection buildSelection = this.getBuildSelection();
        this.myInstantRunContext.setBuildSelection(buildSelection);
        if (buildSelection.getBuildMode() != BuildMode.HOT) {
            LOG.info(buildSelection.why.toString());
        }
        ArrayList<String> args = new ArrayList<String>(commandLineArguments);
        args.addAll(this.myInstantRunContext.getCustomBuildArguments());
        args.addAll(InstantRunBuilder.getInstantRunArguments(buildSelection.getBuildMode()));
        args.addAll(this.getFlightRecorderArguments());
        if (this.myInstantRunContext.getGradlePluginVersion().isAtLeast(3, 0, 0, "alpha", 4, false)) {
            args.add("--no-build-cache");
        }
        LinkedList<String> tasks = new LinkedList<String>();
        tasks.addAll(this.myTasksProvider.getFullBuildTasks());
        return taskRunner.run(tasks, null, args);
    }

    @NotNull
    private BuildSelection getBuildSelection() {
        BuildCause buildCause = this.computeBuildCause(this.myDevice);
        boolean brokenForSecondaryUser = buildCause != BuildCause.INCREMENTAL_BUILD && InstantRunBuilder.hasMultiUser(this.myDevice);
        return new BuildSelection(buildCause, brokenForSecondaryUser);
    }

    private static boolean hasMultiUser(@Nullable IDevice device) {
        return MultiUserUtils.hasMultipleUsers(device, 200L, TimeUnit.MILLISECONDS, false);
    }

    @NotNull
    private BuildCause computeBuildCause(@Nullable IDevice device) {
        if (device == null) {
            return BuildCause.NO_DEVICE;
        }
        int defaultUserId = 0;
        if (!this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), defaultUserId)) {
            return BuildCause.APP_NOT_INSTALLED;
        }
        if (!this.buildTimestampsMatch(device, defaultUserId)) {
            return BuildCause.MISMATCHING_TIMESTAMPS;
        }
        AndroidVersion deviceVersion = device.getVersion();
        if (!InstantRunManager.isInstantRunCapableDeviceVersion(deviceVersion)) {
            return BuildCause.API_TOO_LOW_FOR_INSTANT_RUN;
        }
        if (!InstantRunManager.hasLocalCacheOfDeviceData(device, this.myInstantRunContext)) {
            return BuildCause.FIRST_INSTALLATION_TO_DEVICE;
        }
        if (ApplicationManager.getApplication() != null) {
            TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> FileDocumentManager.getInstance().saveAllDocuments());
        }
        if (this.manifestResourceChanged(device)) {
            return BuildCause.MANIFEST_RESOURCE_CHANGED;
        }
        if (!this.isAppRunning(device) && !deviceVersion.isGreaterOrEqualThan(21)) {
            return BuildCause.FREEZE_SWAP_REQUIRES_API21;
        }
        if (this.myRunContext.isForceColdswap()) {
            return this.myRunContext.couldHaveInvokedHotswap() ? BuildCause.USER_CHOSE_TO_COLDSWAP : BuildCause.USER_REQUESTED_COLDSWAP;
        }
        if (!this.isAppRunning(device)) {
            return BuildCause.APP_NOT_RUNNING;
        }
        if (device.supportsFeature(IDevice.HardwareFeature.TV) || StringUtil.notNullize((String)device.getProperty("ro.product.model")).contains("sdk_google_atv_")) {
            return BuildCause.ANDROID_TV_UNSUPPORTED;
        }
        if (this.myInstantRunContext.usesMultipleProcesses()) {
            return BuildCause.APP_USES_MULTIPLE_PROCESSES;
        }
        return BuildCause.INCREMENTAL_BUILD;
    }

    private boolean isAppRunning(@NotNull IDevice device) {
        boolean isAppRunning;
        try {
            isAppRunning = this.myInstantRunClientDelegate.isAppInForeground(device, this.myInstantRunContext);
        }
        catch (IOException e) {
            InstantRunManager.LOG.warn("IOException while attempting to determine if app is in foreground, assuming app not alive");
            isAppRunning = false;
            InstantRunManager.LOG.warn("Force killing app");
            try {
                device.executeShellCommand("am force-stop " + this.myInstantRunContext.getApplicationId(), (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isAppRunning && this.myRunContext.isSameExecutorAsPreviousSession();
    }

    private static List<String> getInstantRunArguments(@NotNull BuildMode buildMode) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("-P");
        sb.append("android.optional.compilation");
        sb.append("=");
        sb.append(OptionalCompilationStep.INSTANT_DEV.name());
        switch (buildMode) {
            case HOT: {
                break;
            }
            case COLD: {
                sb.append(",").append(OptionalCompilationStep.RESTART_ONLY.name());
                break;
            }
            case FULL: {
                sb.append(",").append(OptionalCompilationStep.FULL_APK.name());
            }
        }
        String compilationSteps = sb.toString();
        String coldSwapMode = AndroidGradleSettings.createProjectProperty((String)"android.injected.coldswap.mode", (String)"MULTIAPK");
        return ImmutableList.of((Object)compilationSteps, (Object)coldSwapMode);
    }

    @NotNull
    private List<String> getFlightRecorderArguments() {
        return this.myFlightRecorderEnabled ? ImmutableList.of((Object)"--info", (Object)"--full-stacktrace") : ImmutableList.of();
    }

    private boolean buildTimestampsMatch(@NotNull IDevice device, @Nullable Integer userId) {
        String localTimestamp;
        InstantRunBuildInfo instantRunBuildInfo = this.myInstantRunContext.getInstantRunBuildInfo();
        String string = localTimestamp = instantRunBuildInfo == null ? null : instantRunBuildInfo.getTimeStamp();
        if (StringUtil.isEmpty((String)localTimestamp)) {
            InstantRunManager.LOG.info("Local build timestamp is empty!");
            return false;
        }
        if (!this.isAppInstalledForUser(device, this.myInstantRunContext.getApplicationId(), userId)) {
            return false;
        }
        String deviceBuildTimestamp = this.myInstantRunClientDelegate.getDeviceBuildTimestamp(device, this.myInstantRunContext);
        InstantRunManager.LOG.info(String.format("Build timestamps: Local: %1$s, Device: %2$s", localTimestamp, deviceBuildTimestamp));
        return localTimestamp.equals(deviceBuildTimestamp);
    }

    private boolean isAppInstalledForUser(@NotNull IDevice device, @NotNull String pkgName, @Nullable Integer userId) {
        InstalledApkCache.InstallState installState = this.myInstalledApkCache.getInstallState(device, pkgName);
        if (installState == null) {
            InstantRunManager.LOG.info("Package " + pkgName + " was not detected on the device.");
            return false;
        }
        if (userId != null && !installState.users.isEmpty() && !installState.users.contains(userId)) {
            LOG.info("Package " + pkgName + " was not installed for default user.");
            return false;
        }
        return true;
    }

    public boolean manifestResourceChanged(@NotNull IDevice device) {
        InstalledPatchCache cache = this.myInstantRunContext.getInstalledPatchCache();
        HashCode currentHash = this.myInstantRunContext.getManifestResourcesHash();
        HashCode installedHash = cache.getInstalledManifestResourcesHash(device, this.myInstantRunContext.getApplicationId());
        return installedHash != null && !installedHash.equals((Object)currentHash);
    }

    static interface InstantRunClientDelegate {
        default public String getDeviceBuildTimestamp(@NotNull IDevice device, @NotNull InstantRunContext instantRunContext) {
            return InstantRunClient.getDeviceBuildTimestamp((IDevice)device, (String)instantRunContext.getApplicationId(), (ILogger)InstantRunManager.ILOGGER);
        }

        default public boolean isAppInForeground(@NotNull IDevice device, @NotNull InstantRunContext context) throws IOException {
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(context);
            try {
                return instantRunClient != null && instantRunClient.getAppState(device) == AppState.FOREGROUND;
            }
            catch (IOException e) {
                Client client = device.getClient(context.getApplicationId());
                if (client == null) {
                    InstantRunManager.LOG.info("Application not running");
                    return false;
                }
                throw e;
            }
        }
    }
}

