/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.android.tools.ir.client.InstantRunClient;
import com.android.tools.ir.client.InstantRunPushFailedException;
import com.android.tools.ir.client.UpdateMode;
import com.android.tools.log.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.xdebugger.XDebugSession;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstantRunManager
implements ProjectComponent {
    public static final String MINIMUM_GRADLE_PLUGIN_VERSION_STRING = "2.3.0-beta1";
    public static final GradleVersion MINIMUM_GRADLE_PLUGIN_VERSION = GradleVersion.parse((String)"2.3.0-beta1");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"InstantRun", (String)ToolWindowId.RUN);
    public static final Logger LOG = Logger.getInstance((String)"#InstantRun");
    public static final ILogger ILOGGER = new LogWrapper(LOG);
    public static final ImmutableSet<String> ALLOWED_MULTI_PROCESSES = ImmutableSet.of((Object)":leakcanary", (Object)":background_crash");
    @NotNull
    private final Project myProject;

    public InstantRunManager(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public static InstantRunManager get(@NotNull Project project) {
        return (InstantRunManager)project.getComponent(InstantRunManager.class);
    }

    @Nullable
    public static AndroidVersion getMinDeviceApiLevel(@NotNull ProcessHandler processHandler) {
        return (AndroidVersion)processHandler.getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
    }

    public static void transferLocalIdToDeviceId(@NotNull IDevice device, @NotNull InstantRunContext context) {
        InstantRunBuildInfo buildInfo = context.getInstantRunBuildInfo();
        assert (buildInfo != null);
        String localTimestamp = buildInfo.getTimeStamp();
        assert (!StringUtil.isEmpty((String)localTimestamp)) : "Unable to detect build timestamp";
        InstantRunClient.transferBuildIdToDevice((IDevice)device, (String)localTimestamp, (String)context.getApplicationId(), (ILogger)ILOGGER);
    }

    public static boolean isInstantRunCapableDeviceVersion(@NotNull AndroidVersion version) {
        return version.getApiLevel() >= 21;
    }

    public static boolean hasLocalCacheOfDeviceData(@NotNull IDevice device, @NotNull InstantRunContext context) {
        InstalledPatchCache cache = context.getInstalledPatchCache();
        return cache.getInstalledManifestResourcesHash(device, context.getApplicationId()) != null;
    }

    @NotNull
    public String getComponentName() {
        return "InstantRunManager";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Nullable
    public static InstantRunClient getInstantRunClient(@NotNull InstantRunContext context) {
        InstantRunBuildInfo buildInfo = context.getInstantRunBuildInfo();
        if (buildInfo == null) {
            return null;
        }
        return new InstantRunClient(context.getApplicationId(), ILOGGER, buildInfo.getSecretToken());
    }

    public UpdateMode pushArtifacts(@NotNull IDevice device, @NotNull InstantRunContext context, @NotNull UpdateMode updateMode) throws InstantRunPushFailedException, IOException {
        InstantRunClient client = InstantRunManager.getInstantRunClient(context);
        assert (client != null);
        InstantRunBuildInfo instantRunBuildInfo = context.getInstantRunBuildInfo();
        assert (instantRunBuildInfo != null);
        if ((updateMode = client.pushPatches(device, instantRunBuildInfo, updateMode, InstantRunSettings.isRestartActivity(), InstantRunSettings.isShowToastEnabled())) == UpdateMode.HOT_SWAP || updateMode == UpdateMode.WARM_SWAP) {
            this.refreshDebugger(context.getApplicationId());
        }
        return updateMode;
    }

    private void refreshDebugger(@NotNull String packageName) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)InstantRunManager.this.myProject);
                if (!debugger.getSessions().isEmpty()) {
                    List breakpoints = debugger.getBreakpointManager().getBreakpoints();
                    for (Breakpoint breakpoint : breakpoints) {
                        if (!breakpoint.isEnabled()) continue;
                        breakpoint.setEnabled(false);
                        breakpoint.setEnabled(true);
                    }
                }
            }
        });
        DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)this.myProject);
        for (final DebuggerSession session : debugger.getSessions()) {
            Client client = (Client)session.getProcess().getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT);
            if (client == null || !client.isValid() || !StringUtil.equals((CharSequence)packageName, (CharSequence)client.getClientData().getClientDescription())) continue;
            session.getProcess().getManagerThread().invoke(new DebuggerCommandImpl(){

                protected void action() throws Exception {
                    JavaExecutionStack stack;
                    DebuggerContextImpl context = session.getContextManager().getContext();
                    SuspendContextImpl suspendContext = context.getSuspendContext();
                    if (suspendContext != null && (stack = suspendContext.getActiveExecutionStack()) != null) {
                        stack.initTopFrame();
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            session.refresh(false);
                            XDebugSession xSession = session.getXDebugSession();
                            if (xSession != null) {
                                xSession.resume();
                            }
                        }
                    });
                }
            });
        }
    }
}

