/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.BuildCause;
import com.android.tools.idea.fd.BuildSelection;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildDetails;
import com.google.wireless.android.sdk.stats.InstantRun;
import com.google.wireless.android.sdk.stats.InstantRunStatus;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunStatsService {
    private static final String UNKOWN_VERSION = "0.0.0";
    private final Object LOCK = new Object();
    private final Project myProject;
    @NotNull
    private UUID mySessionId = UUID.randomUUID();
    private long myBuildStartTime;

    public static InstantRunStatsService get(@NotNull Project project) {
        return (InstantRunStatsService)ServiceManager.getService((Project)project, InstantRunStatsService.class);
    }

    private InstantRunStatsService(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myBuildStartTime = System.currentTimeMillis();
        }
    }

    public void notifyDeployStarted() {
    }

    public void notifyDeployType(@NotNull DeployType type, @NotNull InstantRunContext context, @NotNull IDevice device) {
        BuildSelection selection = context.getBuildSelection();
        BuildCause buildCause = selection == null ? null : selection.why;
        InstantRunBuildInfo buildInfo = context.getInstantRunBuildInfo();
        String verifierStatus = buildInfo == null ? "unknown" : buildInfo.getVerifierStatus();
        this.notifyDeployType(type, InstantRunStatsService.buildCauseToProto(buildCause), InstantRunStatsService.verifierStatusToProto(verifierStatus), context.getGradlePluginVersion().toString(), device);
    }

    public void notifyNonInstantRunDeployType(@NotNull IDevice device) {
        this.notifyDeployType(DeployType.LEGACY, InstantRun.InstantRunIdeBuildCause.NO_INSTANT_RUN, InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS, UNKOWN_VERSION, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeployType(@NotNull DeployType type, @NotNull InstantRun.InstantRunIdeBuildCause buildCause, @NotNull InstantRunStatus.VerifierStatus verifierStatus, @NotNull String androidPluginVersion, @NotNull IDevice device) {
        String sessionId;
        long buildAndDeployTime;
        Object object = this.LOCK;
        synchronized (object) {
            buildAndDeployTime = System.currentTimeMillis() - this.myBuildStartTime;
            if (type == DeployType.FULLAPK || type == DeployType.LEGACY || type == DeployType.SPLITAPK) {
                this.resetSession();
            }
            sessionId = this.mySessionId.toString();
        }
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_BUILD).setKind(AndroidStudioEvent.EventKind.INSTANT_RUN).setInstantRun(InstantRun.newBuilder().setSessionId(sessionId).setBuildTime(buildAndDeployTime).setDeploymentKind(InstantRunStatsService.deployTypeToDeploymentKind(type)).setIdeBuildCause(buildCause).setGradleBuildCause(verifierStatus)).setGradleBuildDetails(GradleBuildDetails.newBuilder().setGradleVersion(InstantRunStatsService.getGradleVersion(this.myProject)).setAndroidPluginVersion(androidPluginVersion));
        if (buildCause == InstantRun.InstantRunIdeBuildCause.API_TOO_LOW_FOR_INSTANT_RUN || buildCause == InstantRun.InstantRunIdeBuildCause.FREEZE_SWAP_REQUIRES_API21 || buildCause == InstantRun.InstantRunIdeBuildCause.FREEZE_SWAP_REQUIRES_WORKING_RUN_AS) {
            studioEvent.setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device));
        } else {
            studioEvent.setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfoApilLevelOnly(device));
        }
        UsageTracker.getInstance().log(studioEvent);
    }

    @NotNull
    private static String getGradleVersion(@NotNull Project project) {
        GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(project);
        return gradleVersion == null ? UNKOWN_VERSION : gradleVersion.toString();
    }

    private static InstantRun.InstantRunIdeBuildCause buildCauseToProto(@Nullable BuildCause buildCause) {
        if (buildCause == null) {
            return InstantRun.InstantRunIdeBuildCause.UNKNOWN_INSTANT_RUN_IDE_BUILD_CAUSE;
        }
        try {
            return InstantRun.InstantRunIdeBuildCause.valueOf((String)buildCause.name());
        }
        catch (IllegalArgumentException e) {
            return InstantRun.InstantRunIdeBuildCause.UNKNOWN_INSTANT_RUN_IDE_BUILD_CAUSE;
        }
    }

    private static InstantRun.InstantRunDeploymentKind deployTypeToDeploymentKind(@NotNull DeployType type) {
        switch (type) {
            case LEGACY: {
                return InstantRun.InstantRunDeploymentKind.LEGACY;
            }
            case FULLAPK: {
                return InstantRun.InstantRunDeploymentKind.FULL_APK;
            }
            case HOTSWAP: {
                return InstantRun.InstantRunDeploymentKind.HOT_SWAP;
            }
            case SPLITAPK: {
                return InstantRun.InstantRunDeploymentKind.SPLIT_APK;
            }
            case WARMSWAP: {
                return InstantRun.InstantRunDeploymentKind.WARM_SWAP;
            }
            case NO_CHANGES: {
                return InstantRun.InstantRunDeploymentKind.NO_CHANGES;
            }
        }
        return InstantRun.InstantRunDeploymentKind.UNKNOWN_INSTANT_RUN_DEPLOYMENT_KIND;
    }

    private static InstantRunStatus.VerifierStatus verifierStatusToProto(@NotNull String verifierStatus) {
        try {
            return InstantRunStatus.VerifierStatus.valueOf((String)verifierStatus);
        }
        catch (IllegalArgumentException e) {
            return InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSession() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mySessionId = UUID.randomUUID();
        }
    }
}

