/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class LogcatRecorder {
    private static final int BUFSIZE = 8192;
    private final Object LOCK = new Object();
    private final EvictingQueue<String> myLogs = EvictingQueue.create((int)8192);
    private final AndroidLogcatService myLogcatService;
    private AtomicReference<IDevice> myDeviceRef = new AtomicReference();
    private AndroidLogcatService.LogcatListener myLogListener;

    public LogcatRecorder(@NotNull AndroidLogcatService logcatService) {
        this.myLogcatService = logcatService;
        this.myLogListener = new MyLogLineListener();
    }

    public void startMonitoring(@NotNull IDevice device, @NotNull LocalDateTime buildTimeStamp) {
        IDevice old = this.myDeviceRef.getAndSet(device);
        if (old != device) {
            if (old != null) {
                this.myLogcatService.removeListener(old, this.myLogListener);
            }
            this.myLogcatService.addListener(device, this.myLogListener);
            LogcatRecorder.enableInstantRunLog(device);
        }
        this.addLog("------------Launch on " + device.getName() + " @ " + buildTimeStamp.toString());
    }

    private static void enableInstantRunLog(IDevice device) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                device.executeShellCommand("setprop log.tag.InstantRun VERBOSE", (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLogs() {
        Object object = this.LOCK;
        synchronized (object) {
            return ImmutableList.copyOf(this.myLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLog(@NotNull String s) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myLogs.add((Object)s);
        }
    }

    private class MyLogLineListener
    implements AndroidLogcatService.LogcatListener {
        private MyLogLineListener() {
        }

        @Override
        public void onLogLineReceived(@NotNull LogCatMessage line) {
            if ("InstantRun".equals(line.getTag())) {
                LogcatRecorder.this.addLog(line.toString());
            }
        }
    }
}

