/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.debugger;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunPositionManager
extends PositionManagerImpl {
    private static Logger LOG = Logger.getInstance(InstantRunPositionManager.class);
    private Map<AndroidVersion, VirtualFile> mySourceFoldersByApiLevel;

    public InstantRunPositionManager(DebugProcessImpl debugProcess) {
        super(debugProcess);
    }

    protected ReferenceType mapClass(ReferenceType type) {
        Value value;
        Field change;
        ReferenceType ret = type;
        if (InstantRunSettings.isInstantRunEnabled() && (change = type.fieldByName("$change")) != null && (value = type.getValue(change)) != null && value.type() instanceof ReferenceType) {
            ret = (ReferenceType)value.type();
        }
        return ret;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        PsiFile file = super.getPsiFileByLocation(project, location);
        if (file == null) {
            return null;
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return file;
        }
        AndroidVersion version = InstantRunPositionManager.getAndroidVersionFromDebugSession(project);
        if (version == null) {
            LOG.debug("getPsiFileByLocation returned null because cannot determine version from device.");
            return file;
        }
        PsiFile source = this.getApiSpecificPsi(project, file, version);
        return source == null ? file : source;
    }

    @Nullable
    protected PsiFile getApiSpecificPsi(@NotNull Project project, @NotNull PsiFile file, @NotNull AndroidVersion version) {
        if (!AndroidSdks.getInstance().isInAndroidSdk((PsiElement)file)) {
            return null;
        }
        String relPath = InstantRunPositionManager.getRelPathFromSourceRoot(project, file);
        if (relPath == null) {
            LOG.debug("getApiSpecificPsi returned null because relPath is null for file: " + file.getName());
            return null;
        }
        return this.getSourceForApiLevel(project, version, relPath);
    }

    @Nullable
    private static AndroidVersion getAndroidVersionFromDebugSession(@NotNull Project project) {
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session == null) {
            return null;
        }
        return (AndroidVersion)session.getDebugProcess().getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
    }

    @Nullable
    private PsiFile getSourceForApiLevel(@NotNull Project project, @NotNull AndroidVersion version, @NotNull String relPath) {
        VirtualFile sourceFolder = this.getSourceFolder(version);
        if (sourceFolder == null) {
            return null;
        }
        VirtualFile vfile = sourceFolder.findFileByRelativePath(relPath);
        if (vfile == null) {
            LOG.debug("getSourceForApiLevel returned null because " + relPath + " is not present in " + sourceFolder);
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(vfile);
    }

    @Nullable
    private VirtualFile getSourceFolder(@NotNull AndroidVersion version) {
        if (this.mySourceFoldersByApiLevel == null) {
            this.mySourceFoldersByApiLevel = InstantRunPositionManager.createSourcesByApiLevel();
            if (this.mySourceFoldersByApiLevel.get(version) == null) {
                LOG.debug("getSourceFolder returned null for version: " + version);
            }
        }
        return this.mySourceFoldersByApiLevel.get(version);
    }

    private static Map<AndroidVersion, VirtualFile> createSourcesByApiLevel() {
        Collection<? extends LocalPackage> sourcePackages = InstantRunPositionManager.getAllPlatformSourcePackages();
        HashMap sourcesByApi = Maps.newHashMap();
        for (LocalPackage localPackage : sourcePackages) {
            TypeDetails typeDetails = localPackage.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.ApiDetailsType)) {
                LOG.warn("Unable to get type details for source package @ " + localPackage.getLocation().getPath());
                continue;
            }
            DetailsTypes.ApiDetailsType details = (DetailsTypes.ApiDetailsType)typeDetails;
            AndroidVersion version = details.getAndroidVersion();
            VirtualFile sourceFolder = VfsUtil.findFileByIoFile((File)localPackage.getLocation(), (boolean)false);
            if (sourceFolder == null || !sourceFolder.isValid()) continue;
            sourcesByApi.put(version, sourceFolder);
        }
        return ImmutableMap.copyOf((Map)sourcesByApi);
    }

    private static Collection<? extends LocalPackage> getAllPlatformSourcePackages() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(InstantRunPositionManager.class));
        return sdkManager.getPackages().getLocalPackagesForPrefix("sources");
    }

    @Nullable
    private static String getRelPathFromSourceRoot(@NotNull Project project, @NotNull PsiFile file) {
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file.getVirtualFile());
        if (sourceRoot == null) {
            LOG.debug("Could not determine source root for file: " + file.getVirtualFile().getPath());
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)sourceRoot);
    }
}

