/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.gradle;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.InstantRun;
import com.android.builder.model.ProductFlavor;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.run.GradleInstantRunContext;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunGradleUtils {
    @NotNull
    public static InstantRunGradleSupport getIrSupportStatus(@Nullable AndroidModuleModel model, @Nullable AndroidVersion deviceVersion) {
        ProductFlavor mergedFlavor;
        block8: {
            if (model == null) {
                return InstantRunGradleSupport.NO_GRADLE_MODEL;
            }
            try {
                InstantRunGradleSupport modelStatus = InstantRunGradleSupport.fromModel(model);
                if (modelStatus != InstantRunGradleSupport.SUPPORTED) {
                    return modelStatus;
                }
            }
            catch (UnsupportedOperationException e) {
                if (!InstantRunGradleUtils.modelSupportsInstantRun(model)) {
                    return InstantRunGradleSupport.GRADLE_PLUGIN_TOO_OLD;
                }
                if (InstantRunGradleUtils.variantSupportsInstantRun(model)) break block8;
                return InstantRunGradleSupport.VARIANT_DOES_NOT_SUPPORT_INSTANT_RUN;
            }
        }
        if (deviceVersion == null) {
            return InstantRunGradleSupport.SUPPORTED;
        }
        IdeVariant variant = model.getSelectedVariant();
        BuildTypeContainer buildTypeContainer = model.findBuildType(model.getSelectedVariant().getBuildType());
        assert (buildTypeContainer != null);
        BuildType buildType = buildTypeContainer.getBuildType();
        if (InstantRunGradleUtils.isLegacyMultiDex(buildType, mergedFlavor = variant.getMergedFlavor()) && !deviceVersion.isGreaterOrEqualThan(AndroidVersion.ART_RUNTIME.getApiLevel())) {
            return InstantRunGradleSupport.LEGACY_MULTIDEX_REQUIRES_ART;
        }
        return InstantRunGradleSupport.SUPPORTED;
    }

    private static boolean isLegacyMultiDex(@NotNull BuildType buildType, @NotNull ProductFlavor mergedFlavor) {
        if (buildType.getMultiDexEnabled() != null) {
            return buildType.getMultiDexEnabled();
        }
        if (mergedFlavor.getMultiDexEnabled() != null) {
            return mergedFlavor.getMultiDexEnabled();
        }
        return false;
    }

    public static boolean variantSupportsInstantRun(@NotNull AndroidModuleModel model) {
        try {
            return model.getSelectedVariant().getMainArtifact().getInstantRun().isSupportedByArtifact();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean modelSupportsInstantRun(@NotNull AndroidModuleModel model) {
        GradleVersion modelVersion = model.getModelVersion();
        return modelVersion == null || modelVersion.compareTo(InstantRunManager.MINIMUM_GRADLE_PLUGIN_VERSION) >= 0;
    }

    @Nullable
    public static AndroidModuleModel getAppModel(@NotNull Module module) {
        AndroidFacet facet = InstantRunGradleUtils.findAppModule(module, module.getProject());
        if (facet == null) {
            return null;
        }
        return AndroidModuleModel.get(facet);
    }

    @Nullable
    public static AndroidFacet findAppModule(@Nullable Module module, @NotNull Project project) {
        if (module != null) {
            assert (module.getProject() == project);
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && facet.isAppProject()) {
                return facet;
            }
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(m);
            if (facet == null || !facet.isAppProject()) continue;
            return facet;
        }
        return null;
    }

    @Nullable
    public static InstantRunBuildInfo getBuildInfo(AndroidModuleModel model) {
        String xml;
        File buildInfo = InstantRunGradleUtils.getLocalBuildInfoFile(model);
        if (!buildInfo.exists()) {
            return null;
        }
        try {
            xml = Files.toString((File)buildInfo, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        return InstantRunBuildInfo.get((String)xml);
    }

    @NotNull
    private static File getLocalBuildInfoFile(@NotNull AndroidModuleModel model) {
        InstantRun instantRun = model.getSelectedVariant().getMainArtifact().getInstantRun();
        return instantRun.getInfoFile();
    }

    @Nullable
    public static InstantRunContext createGradleProjectContext(@NotNull Module module) {
        AndroidFacet appFacet = InstantRunGradleUtils.findAppModule(module, module.getProject());
        if (appFacet == null) {
            return null;
        }
        return InstantRunGradleUtils.createGradleProjectContext(appFacet);
    }

    @Nullable
    public static InstantRunContext createGradleProjectContext(@NotNull AndroidFacet facet) {
        try {
            String pkgName = ApkProviderUtil.computePackageName(facet);
            return new GradleInstantRunContext(pkgName, facet);
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    public static boolean appHasCode(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return true;
        }
        MergedManifest mergedManifest = MergedManifest.get(facet);
        return mergedManifest.getApplicationHasCode();
    }
}

