/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.Flags;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.flags.overrides.PropertyOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;

public final class StudioFlags {
    private static final Flags FLAGS = StudioFlags.createFlags();
    private static final FlagGroup NPW = new FlagGroup(FLAGS, "npw", "New Project Wizard");
    public static final Flag<Boolean> NPW_NEW_PROJECT = Flag.create(NPW, "new.project", "Migrate \"New Project\"", "Use the new wizard framework for the \"New > New Project...\" wizard flow.", true);
    public static final Flag<Boolean> NPW_KOTLIN = Flag.create(NPW, "kotlin", "Enable Kotlin projects", "Add an option in the new wizard flow to create a Kotlin project.", true);
    private static final FlagGroup PROFILER = new FlagGroup(FLAGS, "profiler", "Android Profiler");
    public static final Flag<Boolean> PROFILER_ENABLED = Flag.create(PROFILER, "enabled", "Enable \"Android Profiler\" toolbar", "Enable the new Android Profiler toolbar, which replaces the Android Monitor toolbar and provides more advanced CPU, event, memory, and network profiling information.", true);
    public static final Flag<Boolean> PROFILER_USE_JVMTI = Flag.create(PROFILER, "jvmti", "Enable JVMTI profiling", "Use JVMTI for profiling devices with Android O or newer. This unlocks even more profiling features for these devices.", true);
    public static final Flag<Boolean> PROFILER_USE_SIMPLEPERF = Flag.create(PROFILER, "simpleperf", "Enable Simpleperf profiling", "Use Simpleperf for CPU profiling on devices with Android O or newer. Simpleperf is a native profiler tool built for Android.", false);
    public static final Flag<Boolean> PROFILER_SHOW_THREADS_VIEW = Flag.create(PROFILER, "threads.view", "Show network threads view", "Show a view in the network profiler that groups connections by their creation thread.", false);
    public static final Flag<Boolean> PROFILER_USE_LIVE_ALLOCATIONS = Flag.create(PROFILER, "livealloc", "Enable JVMTI-based live allocation tracking", "For Android O or newer, allocations are tracked all the time while inside the Memory Profiler.", true);
    private static final FlagGroup NELE = new FlagGroup(FLAGS, "nele", "Layout Editor");
    public static final Flag<Boolean> NELE_ANIMATIONS_PREVIEW = Flag.create(NELE, "animated.preview", "Show preview animations toolbar", "Show an animations bar that allows playback of vector drawable animations.", false);
    public static final Flag<Boolean> NELE_SAMPLE_DATA = Flag.create(NELE, "mock.data", "Enable \"Sample Data\" for the layout editor", "Enables the use of @sample references in the tools namespace to use sample data.", true);
    public static final Flag<Boolean> NELE_MOCKUP_EDITOR = Flag.create(NELE, "mockup.editor", "Enable the Mockup Editor", "Enable the Mockup Editor to ease the creation of Layouts from a design file.", false);
    public static final Flag<Boolean> NELE_LIVE_RENDER = Flag.create(NELE, "live.render", "Enable the Live Render", "Enable the continuous rendering of the surface when moving/resizing components.", false);
    public static final Flag<Boolean> NELE_WIDGET_ASSISTANT = Flag.create(NELE, "widget.assistant", "Enable the properties panel Widget Assistant", "Enable the Widget Assistant that provides common shortcuts for certain widgets.", false);
    public static final Flag<Boolean> NELE_CONVERT_VIEW = Flag.create(NELE, "convert.view", "Enable the Convert View Action", "Enable the Convert View Action when right clicking on a component", false);
    private static final FlagGroup ASSISTANT = new FlagGroup(FLAGS, "assistant", "Assistants");
    public static final Flag<Boolean> CONNECTION_ASSISTANT_ENABLED = Flag.create(ASSISTANT, "connection.enabled", "Enable the connection assistant", "If enabled, user can access the Connection Assistant under \"Tools\" and \"Deploy Target Dialog\"", false);
    public static final Flag<Boolean> NELE_TARGET_RELATIVE = Flag.create(NELE, "target.relative", "Enable the target architecture in relative layout", "Enable the new Target architecture in relative layout", false);
    private static final FlagGroup RUNDEBUG_GROUP = new FlagGroup(FLAGS, "rundebug", "Run/Debug");
    public static final Flag<Boolean> RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED = Flag.create(RUNDEBUG_GROUP, "logcat.console.output.enabled", "Show logcat process output in Run/Debug console window", "When running or debugging an Android process, output the logcat output of the process in the console window.", true);
    private static final FlagGroup GRADLE_IDE = new FlagGroup(FLAGS, "gradle.ide", "Gradle/IDE");
    public static final Flag<Boolean> GRADLE_INVOCATIONS_INDEXING_AWARE = Flag.create(GRADLE_IDE, "indexing.aware", "Execute gradle actions in indexing-aware mode", "Make Gradle actions and IDE indexing mutually exclusive to allow better utilisation of machine resources.", false);

    @NotNull
    private static Flags createFlags() {
        Application app = ApplicationManager.getApplication();
        FlagOverrides userOverrides = app != null && !app.isUnitTestMode() ? StudioFlagSettings.getInstance() : new DefaultFlagOverrides();
        return new Flags(userOverrides, new PropertyOverrides());
    }

    private StudioFlags() {
    }
}

