/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFlagsDialog
extends DialogWrapper {
    public static final String TITLE = "Edit Studio Flags";
    private final FlagOverrides myBackupOverrides;
    private final BindingsManager myBindings;
    private final ListMultimap<FlagGroup, Flag<?>> myGroupedFlags;
    private JPanel myRootPanel;
    private JPanel myContentPanel;
    private JBScrollPane myScrollPane;

    public StudioFlagsDialog() {
        super(null);
        this.$$$setupUI$$$();
        this.myBackupOverrides = new DefaultFlagOverrides();
        this.myBindings = new BindingsManager();
        this.setTitle(TITLE);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.myRootPanel.setPreferredSize(new Dimension((int)((double)screenSize.width * 0.5), (int)((double)screenSize.height * 0.8)));
        this.myGroupedFlags = StudioFlagsDialog.collectAllFlags();
        this.replaceOverrides(this.myBackupOverrides, StudioFlagSettings.getInstance());
        this.myGroupedFlags.asMap().entrySet().stream().sorted(Comparator.comparing(entry -> ((FlagGroup)entry.getKey()).getDisplayName())).forEach(entry -> {
            FlagGroup group = (FlagGroup)entry.getKey();
            Collection flags = (Collection)entry.getValue();
            if (flags.isEmpty()) {
                return;
            }
            JPanel groupPanel = new JPanel((LayoutManager)new VerticalFlowLayout(5, 0));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(group.getDisplayName());
            titledBorder.setTitleFont(titledBorder.getTitleFont().deriveFont(1, titledBorder.getTitleFont().getSize() + 2));
            groupPanel.setBorder(titledBorder);
            boolean firstFlag = true;
            for (Flag flag : flags) {
                JPanel flagPanel = new JPanel((LayoutManager)new VerticalFlowLayout(5, 0));
                if (!firstFlag) {
                    flagPanel.add(new JSeparator(0));
                }
                JBLabel name = new JBLabel(flag.getDisplayName());
                name.setFont(UIUtil.getLabelFont().deriveFont(1));
                name.setToolTipText(flag.getId());
                JTextArea description = new JTextArea(flag.getDescription());
                description.setFont(UIUtil.getLabelFont());
                description.setLineWrap(true);
                description.setWrapStyleWord(true);
                description.setEditable(false);
                description.setOpaque(false);
                description.setForeground(UIUtil.getInactiveTextColor());
                final FlagEditor<?> flagEditor = this.createFlagEditor(flag);
                HyperlinkLabel resetLink = new HyperlinkLabel("Reset to default");
                resetLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        flagEditor.flagProperty().clearOverride();
                    }
                });
                this.myBindings.bind(new VisibleProperty((JComponent)resetLink), flagEditor.flagProperty().isOverridden());
                JPanel flagEditorPanel = new JPanel(new FlowLayout(0, 5, 0));
                flagEditorPanel.add(flagEditor.editorComponent());
                flagEditorPanel.add((Component)resetLink);
                flagPanel.add((Component)name);
                flagPanel.add(description);
                flagPanel.add(flagEditorPanel);
                groupPanel.add(flagPanel);
                firstFlag = false;
            }
            this.myContentPanel.add(groupPanel);
        });
        this.init();
        ApplicationManager.getApplication().invokeLater(() -> this.myScrollPane.getVerticalScrollBar().setValue(0), ModalityState.any());
    }

    private void replaceOverrides(FlagOverrides overridesDest, ImmutableFlagOverrides overridesSrc) {
        overridesDest.clear();
        for (Flag flag : this.myGroupedFlags.values()) {
            String flagValue = overridesSrc.get(flag);
            if (flagValue == null) continue;
            overridesDest.put(flag, flagValue);
        }
    }

    private static ListMultimap<FlagGroup, Flag<?>> collectAllFlags() {
        ArrayListMultimap allFlags = ArrayListMultimap.create();
        for (Field field : StudioFlags.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object instance = field.get(null);
                if (!(instance instanceof Flag)) continue;
                Flag flag = (Flag)instance;
                allFlags.put((Object)flag.getGroup(), (Object)flag);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return allFlags;
    }

    @NotNull
    private FlagEditor<?> createFlagEditor(Flag<?> flag) {
        if (flag.get().getClass() == Boolean.class) {
            final Flag<?> boolFlag = flag;
            return new FlagEditor<Boolean>(){
                FlagProperty<Boolean> myFlagProperty;
                {
                    this.myFlagProperty = new FlagProperty(boolFlag);
                }

                @Override
                @NotNull
                public FlagProperty<Boolean> flagProperty() {
                    return this.myFlagProperty;
                }

                @Override
                @NotNull
                public JComponent editorComponent() {
                    JPanel choicesPanel = new JPanel(new FlowLayout(0, 2, 0));
                    JRadioButton onButton = new JRadioButton("On");
                    JRadioButton offButton = new JRadioButton("Off");
                    ButtonGroup group = new ButtonGroup();
                    group.add(onButton);
                    group.add(offButton);
                    StudioFlagsDialog.this.myBindings.bind(new SelectedProperty(onButton), this.myFlagProperty);
                    StudioFlagsDialog.this.myBindings.bind(new SelectedProperty(offButton), BooleanExpressions.not(this.myFlagProperty));
                    onButton.addActionListener(l -> this.myFlagProperty.set(true));
                    offButton.addActionListener(l -> this.myFlagProperty.set(false));
                    choicesPanel.add(onButton);
                    choicesPanel.add(offButton);
                    return choicesPanel;
                }
            };
        }
        throw new IllegalStateException(String.format("Unhandled flag type (\"%s\"): Flag<%s>", flag.getId(), flag.get().getClass().getSimpleName()));
    }

    public void doCancelAction() {
        this.replaceOverrides(StudioFlagSettings.getInstance(), this.myBackupOverrides);
        super.doCancelAction();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getCancelAction(), this.getOKAction()};
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    private void createUIComponents() {
        this.myContentPanel = new JPanel((LayoutManager)new VerticalFlowLayout(5, 15));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jBScrollPane, "Center");
        JPanel jPanel2 = this.myContentPanel;
        jBScrollPane.setViewportView(jPanel2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static final class FlagProperty<T>
    extends AbstractProperty<T> {
        private final Flag<T> myFlag;
        private final BoolProperty myOverridden;

        public FlagProperty(Flag<T> flag) {
            this.myFlag = flag;
            this.myOverridden = new BoolValueProperty(this.myFlag.isOverridden());
        }

        @Override
        @NotNull
        public T get() {
            return this.myFlag.get();
        }

        public ObservableBool isOverridden() {
            return this.myOverridden;
        }

        @Override
        protected void setDirectly(@NotNull T value) {
            this.myFlag.override(value);
            this.myOverridden.set(true);
        }

        public void clearOverride() {
            this.myFlag.clearOverride();
            this.myOverridden.set(false);
            this.notifyInvalidated();
        }
    }

    private static interface FlagEditor<T> {
        @NotNull
        public FlagProperty<T> flagProperty();

        @NotNull
        public JComponent editorComponent();
    }
}

